#ifndef FADFORMAT_H_SEEN
#define FADFORMAT_H_SEEN

#include "../drsdaq/RawDataCTX.h"

//
// Commands for FAD
//
#define CMD_Start 0xC000		// Start Run
#define CMD_Stop 0x3000			// Stop Run
#define CMD_Trigger 0xA000 		// single trigger
#define CMD_DENABLE 0x0600      // DENABLE line HIGH
#define CMD_DDISABLE 0x0700     // DENABLE line LOW
#define CMD_DWRITE_RUN 0x0800   // DWRITE possibly HIGH
#define CMD_DWRITE_STOP 0x0900  // DWRITE always LOW
#define CMD_SCLK_ON 0x1000  
#define CMD_SCLK_OFF 0x1100
#define CMD_PS_DIRINC 0x1200
#define CMD_PS_DIRDEC 0x1300
#define CMD_PS_DO 0x1400
#define CMD_PS_RESET 0x1700
#define CMD_SRCLK_ON 0x1500
#define CMD_SRCLK_OFF 0x1600
#define CMD_Trigger_C 0xB000 	// continous trigger
#define CMD_Trigger_S 0x2000 	// stop continous trigger
#define CMD_Read 0x0A00 		// read from Config-RAM
#define CMD_Write 0x0500 		// write to Config-RAM

//
// Other definitions
//
#define MAX_ADDR 0xFF // highest address in Config-RAM
#define BADDR_ROI 0x00 // Baseaddress ROI-Values
#define BADDR_DAC 0x24 // Baseaddress DAC-Values
#define MAX_VAL 65535
#define MAX_ROIVAL 1024
#define MAX_DACVAL 65535

const unsigned int NChannels	= 9;
const unsigned int NBins		= 1024;
const unsigned int NChips 		= 4;
const unsigned int NTemp		= 4;
const unsigned int NDAC			= 8;

//
// Data structures
//
typedef struct {
	unsigned short start_package_flag;
	unsigned short package_length;
	unsigned short version_no;
	unsigned long trigger_id;
	unsigned char trigger_type;
	unsigned char trigger_crc;
	unsigned long local_trigger_id;
	unsigned char local_trigger_type;
	unsigned char local_trigger_crc;
	unsigned short board_id;
	short drs_temperature[NTemp];
	unsigned short dac[NDAC];
}  __attribute__((__packed__)) PEVNT_HEADER;

typedef struct {
	unsigned short id;
	unsigned short start_cell;
	unsigned short roi;
	unsigned short adc_data[];
}  __attribute__((__packed__)) PCHANNEL;

typedef struct {
	unsigned short package_crc;
	unsigned short end_package_flag;
}  __attribute__((__packed__)) PEVNT_FOOTER;

#endif
