//
//  FADctrl
//

#include <stdio.h>
#include <readline/history.h>

#include "FAD.h"

const char READLINE_HIST_FILE[] = "/tmp/.history.FADctrl";

void OpenOtherSockets();

// ================
//   Main program
// ================

int main() {

  // Uses getc() for readline library (allows interruption by signal)
  rl_getc_function = getc;
  
  // Load history buffer
  read_history(READLINE_HIST_FILE);

  system("clear");
  printf("\n*** FADctrl (built %s, %s, revision %s) *** \n\n",__DATE__, __TIME__, REVISION);

  // Construct main instance (static ensures destructor is called with exit())
  static FAD M;

  // Do not kill process if writing to closed socket
  signal(SIGPIPE,SIG_IGN);

  // Create thread to connect to other sockets
  int RetVal;
  pthread_t Thread;
  if ((RetVal = pthread_create(&Thread, NULL, (void * (*)(void *)) OpenOtherSockets, NULL)) != 0) {
    printf("pthread_create() failed for OpenOtherSockets(%s)\n", strerror(RetVal));
	exit(EXIT_FAILURE);
  }

  // Initialise all boards
  M.PrintMessage("Initalizing all boards...\n");

  DimClient::sendCommand(SERVER_NAME"/Command", "dwrite off");
  DimClient::sendCommand(SERVER_NAME"/Command", "domino off");
  sleep(1);

  DimClient::sendCommand(SERVER_NAME"/Command", "dac 0 21000");
  DimClient::sendCommand(SERVER_NAME"/Command", "dac 1 0");
  DimClient::sendCommand(SERVER_NAME"/Command", "dac 2-3 5000");
  DimClient::sendCommand(SERVER_NAME"/Command", "dac 4-7 28800");
  sleep (1);

  DimClient::sendCommand(SERVER_NAME"/Command", "roi all 10");
  DimClient::sendCommand(SERVER_NAME"/Command", "address 44 29");
  sleep (1);

  DimClient::sendCommand(SERVER_NAME"/Command", "trigger");
  sleep (1);

  DimClient::sendCommand(SERVER_NAME"/Command", "address 44 30");
  sleep (1);

  DimClient::sendCommand(SERVER_NAME"/Command", "trigger");
  sleep (1);

  DimClient::sendCommand(SERVER_NAME"/Command", "address 44 0");
  sleep (1);

  DimClient::sendCommand(SERVER_NAME"/Command", "trigger");
  DimClient::sendCommand(SERVER_NAME"/Command", "domino on");
  DimClient::sendCommand(SERVER_NAME"/Command", "dwrite on");
  DimClient::sendCommand(SERVER_NAME"/Command", "roi all 1024");
  sleep (1);

  //EmptySockets(SocketDescriptor, 8, 750000L);
  M.PrintMessage("Finished initalizing all boards\n");
  
  // Command loop
  char *Command;
  std::string LastHist;

  while (!M.ExitRequest) {
    Command = readline("\rFADctrl>");

	// Check for interruption by signal
    if (Command == NULL) continue;

	// Add command to history
    if(strlen(Command) > 0 && LastHist != Command) {
	  add_history(Command);
	  LastHist = Command;
	}

    // Process command
	DimClient::sendCommand(SERVER_NAME"/Command", Command);
    free(Command);
  }
  
  // Save history buffer  
  int Ret = write_history(READLINE_HIST_FILE);
  if (Ret != 0 ) printf("Error writing history file to '%s' (%s)\n", READLINE_HIST_FILE, strerror(Ret));

  // Terminate thread for other sockets  
  if ((Ret = pthread_cancel(Thread)) != 0) printf("Error: Could not request thread cancellation (%s)\n", strerror(Ret));
  if ((Ret = pthread_join(Thread, NULL)) != 0) printf("pthread_join() failed (%s)\n", strerror(Ret));
}


// ====================
//   OpenOtherSockets()
// ====================

void OpenOtherSockets() {

  static char Hostname[] = "192.33.99.225";
  int List[] = {5001, 5002, 5003, 5004, 5005, 5006, 5007};
  int Socket[sizeof(List)/sizeof(int)], MaxSocketNum=0, Ret;
  fd_set DescriptorList;
  char Buffer[1000000];

  // Resolve hostname
  struct hostent *Host = gethostbyname(Hostname);
  if (Host == 0) {
    printf("OtherSockets: Could not resolve host name for %s\n", Hostname);
    return;
  }

  // Connect to server
  struct sockaddr_in SocketAddress;
  SocketAddress.sin_family = PF_INET;
  SocketAddress.sin_addr = *(struct in_addr*) Host->h_addr;

  for (unsigned int i=0; i<sizeof(List)/sizeof(int); i++) {
	// Open socket descriptor
	if ((Socket[i] = socket(PF_INET, SOCK_STREAM, 0)) == -1) {
      printf("OtherSockets: Could not open socket for port %d (%s)\n", List[i], strerror(errno));
      return;
	}

	// Determine highest socket number for select()
	if (Socket[i] > MaxSocketNum) MaxSocketNum = Socket[i];
	 
	// Connect to server
    SocketAddress.sin_port = htons((unsigned short) List[i]);
	if (connect(Socket[i], (struct sockaddr *) &SocketAddress, sizeof(SocketAddress)) == -1) {
      printf("OtherSockets: Could not connect to port %d (%s)\n", List[i], strerror(errno));
      return;
	}
  }
  
  while(true) {
    // Wait for data from terminal (stdin) or from sockets
    FD_ZERO(&DescriptorList);   
    for (unsigned int i=0; i<sizeof(List)/sizeof(int); i++) FD_SET(Socket[i], &DescriptorList);
    if (select(MaxSocketNum+1, &DescriptorList, NULL, NULL, NULL) == -1) {
      perror("OtherSockets: Error with select()");
      break;
    }
	
	// Data from socket
	for (unsigned int i=0; i<sizeof(List)/sizeof(int); i++) if (FD_ISSET(Socket[i], &DescriptorList)) {
	  Ret = read(Socket[i], Buffer, sizeof(Buffer));
      if(Ret == 0) printf("OtherSockets: Connection to port %d not existing anymore\n", List[i]);
      else if (Ret == -1) printf("OtherSockets: Error reading from port %d (%s)\n", List[i], strerror(errno));
      else printf("OtherSockets: Read %d bytes from port %d\n", Ret, List[i]);
    }
  }

  // Close all sockets
  for (unsigned int i=0; i<sizeof(List)/sizeof(int); i++) {
	if ((Socket[i] != -1) && (close(Socket[i]) == -1)) {
	  printf("OtherSockets: Could not close socket of port %d (%s)", List[i], strerror(errno));  
	}
  }
}
