#ifndef MTASK_H
#define MTASK_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MTask                                                                   //
//                                                                         //
// Abstract base class for a task                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MINPUTSTREAMID_H
#include "MInputStreamID.h"
#endif

class TOrdCollection;

class MFilter;
class MParList;

class MTask : public MInputStreamID
{
private:
    TOrdCollection *fListOfBranches; // List of Branch names for auto enabeling scheme

    const MFilter *fFilter;          // Filter for conditional task execution

    Bool_t fIsPreprocessed;          // Indicates the success of the PreProcessing (set by MTaskList)
    UInt_t fNumExecutions;           // Number of Excutions

    virtual Bool_t PreProcess(MParList *pList);
    virtual Bool_t Process();
    virtual Bool_t PostProcess();

protected:
    void AddToBranchList(const char *b);
    void AddToBranchList(const TString &str)
    {
        AddToBranchList((const char*)str);
    }

public:
    MTask(const char *name=NULL, const char *title=NULL);
    MTask(MTask &t);
    virtual ~MTask();

    void SetFilter(const MFilter *filter) { fFilter=filter; }
    virtual void PrintStatistics(const Int_t lvl=0) const;

    Bool_t CallPreProcess(MParList *plist);
    Bool_t CallProcess();
    Bool_t CallPostProcess();

    const TOrdCollection *GetListOfBranches() const { return fListOfBranches; }

    ClassDef(MTask, 0)		//Abstract base class for a task
};

#endif
