library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- use IEEE.NUMERIC_STD.ALL;

package ftm_array_types is



--- std_logic_vector (31 downto 0)
--- type clk_cond_array_type is array (0 to 8) of integer range 0 to 2**32 - 1;

  type clk_cond_array_type is array (0 to 8) of std_logic_vector (31 downto 0);
  constant DEFAULT_Clk_Cond : clk_cond_array_type := (x"80000000", x"00038000", x"00010101", x"10000908", x"A0032A09", x"0082000B", x"020A000D", x"0830280E", x"1400FA0F");
  -- This array contains the settings to be leaded in the clock conditioner
  -- LMK03000 on the FTM board
  -- The entrys of the array are:
  --    R0 for Reset only, i.e. only bit 31 is set this resets the LMK0300
  --    R0
  --    R1
  --    R8
  --    R9
  --    R11
  --    R13
  --    R14  
  --    R15
  --   constant DEFAULT_Clk_Cond : clk_cond_array_type := (x"80000000", x"00010100", x"00010101", x"10000908", x"A0032A09", x"0082000B", x"020A000D", x"0830280E", x"2000960F");
-- OLD: constant DEFAULT_Clk_Cond : clk_cond_array_type := (x"80000000", x"00038000", x"00010101", x"10000908", x"A0032A09", x"0082000B", x"020A000D", x"1830280E", x"1400FA0F");
end ftm_array_types;
