--
-- VHDL Architecture FACT_FAD_lib.spi_controller.beha
--
-- Created:
--          by - Benjamin Krumm.UNKNOWN (EEPC8)
--          at - 10:37:20 12.04.2010
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--
-- modified by Q. Weitzel
--
-------------------------------------------------------------------------------
--
-- modified by Patrick Vogler
-- September 17 2010
--
-- modified to be used as a Microwire interface to control the clock
-- conditioner LMK03000 on the FTM board
-------------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE ieee.std_logic_unsigned.all;

library FTM_definitions_test3;
USE FTM_definitions_test3.ftm_array_types.all;



ENTITY FTM_test3_microwire_controller IS
   PORT(
  --    clk               : IN     std_logic;              -- 250MHz
      clk_uwire         : IN     std_logic;              -- sclk
      data_uwire        : OUT    std_logic := '0';       -- mosi
      le_uwire          : OUT    std_logic := '1';       -- Latch Enable = chip select
      clk_cond_array    : IN     clk_cond_array_type;    -- data to be loaded
                                                         -- into the clock conditioner
      config_start      : IN     std_logic;
      config_ready      : OUT    std_logic := '0'; 
      config_started    : OUT    std_logic := '0'
      );
END FTM_test3_microwire_controller ;


ARCHITECTURE beha OF FTM_test3_microwire_controller IS
  
  type TYPE_uWire_STATE is (IDLE, LOAD_SHIFT_REG, SHIFT);   
  signal uwire_state        : TYPE_uWire_STATE := IDLE;  
  signal register_count     : integer range 0 to 9 := 0;
  signal bit_count          : integer range 0 to 32 := 0;
  signal shift_reg          : std_logic_vector (31 downto 0) := (others => '0');

  
BEGIN
  
  uwire_write_proc: process (clk_uwire)
  begin
    
     if falling_edge(clk_uwire) then
       
       case uwire_state is
         
        when IDLE =>
          
          le_uwire <= '1';
          config_ready <= '1';
          config_started <= '0';
          bit_count <= 0;
          register_count <= 0;
          data_uwire <= '0';
          
          if (config_start = '1') then
            config_ready <= '0';
            uwire_state <=  LOAD_SHIFT_REG; 
          end if;

          
        when LOAD_SHIFT_REG =>
          bit_count <= 0;
          config_started <= '1';	         
			 shift_reg <= clk_cond_array(register_count)(31 downto 0);
          register_count <= register_count + 1;
--			 le_uwire <= '0';
          uwire_state  <= SHIFT;  
                    

       when SHIFT =>
          data_uwire  <= shift_reg(31);
			 le_uwire <= '0';
          shift_reg <= shift_reg(30 downto 0) & shift_reg(31);			 
          bit_count <= bit_count + 1;          			 
          if ((bit_count = 32)AND(register_count = 9)) then
				le_uwire <= '1';
            uwire_state  <= IDLE;
          elsif ((bit_count = 32)AND(NOT(register_count = 9))) then
				le_uwire <= '1';
            uwire_state  <= LOAD_SHIFT_REG;
          else
            uwire_state  <= SHIFT;
          end if;
          
      end case;      
    end if;
    
  end process  uwire_write_proc;
      
END ARCHITECTURE beha;
