--
-- VHDL Architecture FACT_FAD_lib.rs485_interface.beha
--
-- Created:
--          by - Benjamin Krumm.UNKNOWN (EEPC8)
--          at - 13:24:23 08.06.2010
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--
--
-- modified for FTU design by Q. Weitzel, 30 July 2010
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

-- library ftu_definitions;
-- USE ftu_definitions.ftu_array_types.all;
-- USE ftu_definitions.ftu_constants.all;

ENTITY FTM_test8_rs485_interface IS
  GENERIC( 
    CLOCK_FREQUENCY : integer := 50000000;
    BAUD_RATE       : integer := 250000
  );
  PORT( 
    clk      : IN     std_logic;
    -- RS485
    rx_d     : IN     std_logic;
    rx_en    : OUT    std_logic;
    tx_d     : OUT    std_logic;
    tx_en    : OUT    std_logic;
    -- FPGA
    rx_data  : OUT    std_logic_vector (7 DOWNTO 0);
    --rx_busy  : OUT    std_logic  := '0';
    rx_valid : OUT    std_logic  := '0';
    tx_data  : IN     std_logic_vector (7 DOWNTO 0);
    tx_busy  : OUT    std_logic  := '0';
    tx_start : IN     std_logic
  );

END FTM_test8_rs485_interface;

ARCHITECTURE beha OF FTM_test8_rs485_interface IS
  
  signal flow_ctrl : std_logic := '0'; -- '0' -> RX enable, '1' -> TX enable

  --transmit
  signal tx_start_f : std_logic := '0';
  signal tx_sr : std_logic_vector(10 downto 0) := (others => '1');  -- start bit, 8 data bits, 2 stop bits
  signal tx_bitcnt : integer range 0 to 11 := 11;
  signal tx_cnt : integer range 0 to ((CLOCK_FREQUENCY / BAUD_RATE) - 1);

  --receive
  signal rx_dsr : std_logic_vector(3 downto 0) := (others => '1');
  signal rx_sr : std_logic_vector(7 downto 0) := (others => '0');
  signal rx_bitcnt : integer range 0 to 11 := 11;
  signal rx_cnt : integer range 0 to ((CLOCK_FREQUENCY / BAUD_RATE) - 1);
  
BEGIN

  -- Senden
  tx_data_proc: process(clk)
  begin
    if rising_edge(clk) then
      tx_start_f <= tx_start;
      if (tx_start = '1' or tx_bitcnt < 11) then
        flow_ctrl <= '1';
      else
        flow_ctrl <= '0';
      end if;
      if (tx_start = '1' and tx_start_f = '0') then -- steigende Flanke, los gehts
        tx_cnt <= 0;                                -- Zaehler initialisieren
        tx_bitcnt <= 0;                      
        tx_sr <= "11" & tx_data & '0';              -- 2 x Stopbit, 8 Datenbits, Startbit, rechts gehts los
      else
        if (tx_cnt < (CLOCK_FREQUENCY/BAUD_RATE) - 1) then
          tx_cnt <= tx_cnt + 1;
        else  -- naechstes Bit ausgeben  
          if (tx_bitcnt < 11) then
            tx_cnt <= 0;
            tx_bitcnt <= tx_bitcnt + 1;
            tx_sr <= '1' & tx_sr(tx_sr'left downto 1);
          end if;
        end if;
      end if;
  end if;
  end process;

  tx_en <= flow_ctrl;
  tx_d <= tx_sr(0);  -- LSB first
  tx_busy <= '1' when (tx_start = '1' or tx_bitcnt < 11) else '0';

  -- Empfangen
  rx_data_proc: process(clk) 
  begin
    if rising_edge(clk) then
      rx_dsr <= rx_dsr(rx_dsr'left - 1 downto 0) & rx_d;
      if (rx_bitcnt < 11) then    -- Empfang laeuft
        if (rx_cnt < (CLOCK_FREQUENCY/BAUD_RATE) - 1) then 
          rx_cnt <= rx_cnt + 1;
        else
          rx_cnt <= 0; 
          rx_bitcnt <= rx_bitcnt + 1;
          if (rx_bitcnt < 9) then
            rx_sr <= rx_dsr(rx_dsr'left - 1) & rx_sr(rx_sr'left downto 1); -- rechts schieben, weil LSB first
          else 
            rx_valid <= '1';
          end if;
        end if;
      else
        if (rx_dsr(3 downto 2) = "10") then   -- warten auf Start bit
          rx_valid <= '0';
          rx_cnt <= ((CLOCK_FREQUENCY / BAUD_RATE) - 1) / 2;
          rx_bitcnt <= 0;
        end if;
      end if;
    end if;
  end process;
  
  rx_en <= flow_ctrl;
  rx_data <= rx_sr;
  --rx_busy <= '1' when (rx_bitcnt < 11) else '0';

END ARCHITECTURE beha;
