--
-- VHDL Architecture FACT_FAD_lib.rs485_receiver.beha
--
-- Created:
--          by - Benjamin Krumm.UNKNOWN (EEPC8)
--          at - 12:16:57 11.06.2010
--
-- using Mentor Graphics HDL Designer(TM) 2009.2 (Build 10)
--
--
-- modified for FTU design by Q. Weitzel, 13 September 2010
-- timeout added, Q. Weitzel, 26 October 2010
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

library ftu_definitions;
USE ftu_definitions.ftu_constants.all;

ENTITY FTU_rs485_receiver IS
  generic(
    RX_BYTES  : integer := RS485_BLOCK_WIDTH / 8; -- no. of bytes to receive
    RX_WIDTH  : integer := RS485_BLOCK_WIDTH
  );
  port(
    rec_clk   : in  std_logic;
    --rx_busy   : in  std_logic;
    rec_din   : in  std_logic_vector(7 downto 0);
    rec_den   : in  std_logic;
    rec_dout  : out std_logic_vector(RX_WIDTH - 1 downto 0) := (others => '0');
    rec_valid : out std_logic := '0'
  );
END ENTITY FTU_rs485_receiver;

ARCHITECTURE beha OF FTU_rs485_receiver IS
  
  signal rxcnt       : integer range 0 to RX_BYTES := 0;
  signal rxsr        : std_logic_vector(3 downto 0) := (others => '0');
  signal timeout_cnt : integer range 0 to RS485_TIMEOUT + 1 := 0;
  
BEGIN
  
  rx_data_proc : process(rec_clk)
  begin
    if rising_edge(rec_clk) then
      rxsr <= rxsr(2 downto 0) & rec_den;
      if (timeout_cnt = RS485_TIMEOUT) then
        rec_dout <= (others => '0');
        rxcnt <= 0;
        rec_valid <= '0';
      else        
        if (rxsr(3 downto 2) = "01") then -- identify rising edge
          rec_dout((rxcnt*rec_din'length + rec_din'length - 1) downto (rxcnt*rec_din'length)) <= rec_din;
          rxcnt <= rxcnt + 1;
          if (rxcnt < RX_BYTES - 1) then
            rec_valid <= '0';
          else
            rxcnt <= 0;
            rec_valid <= '1';
          end if;
        end if;
      end if;
    end if;
  end process rx_data_proc;

  rx_timeout_proc : process(rec_clk)
  begin
    if rising_edge(rec_clk) then
      if (rxcnt > 0) then
        timeout_cnt <= timeout_cnt + 1;
      else
        timeout_cnt <= 0;
      end if;
    end if;  
  end process rx_timeout_proc;
  
END ARCHITECTURE beha;
