#ifndef HV_H_SEEN
#define HV_H_SEEN

#include <termios.h>		// POSIX terminal control definitions
#include <fcntl.h>		// File control definitions => fcntl() in fcn OpenPort()
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <string>

#include "dis.hxx"

#define MAX_NUM_BOARDS 13	// Maximum number of boards per crate
#define NUM_CHANNELS 32		// Channels per bias board
#define BAUDRATE B115200

class User;

class Crate {
  
    class User *m;
	int CrateNumber;
	int fDescriptor; 
	DimService *NameService;
	char ReadBuffer[3];

	int Communicate(unsigned char*, int);
	void ClearVoltageArrays();
   
  public:
    Crate(std::string, int, class User *);
    ~Crate();

    char *Name;
	DimService *BiasVolt;

	int Current[MAX_NUM_BOARDS][NUM_CHANNELS];
	bool OC[MAX_NUM_BOARDS][NUM_CHANNELS];
	bool ResetHit;
	bool WrapOK;
	int WrapCount;
	int ErrorCount;

	int DAC[MAX_NUM_BOARDS][NUM_CHANNELS];      // Voltage in DAC units
	double Volt[MAX_NUM_BOARDS][NUM_CHANNELS];  // Voltage in Volt

	bool InitOK;

	int SystemReset();
	int ReadChannel(unsigned int, unsigned int);
	int GlobalSet(unsigned int);
	int ChannelSet(int, int, unsigned int);
	bool Synch();
};

#endif
