--------------------------------------------------------------------------------
-- Company:       ETH Zurich, Institute for Particle Physics
-- Engineer:      Q. Weitzel, P. Vogler
--
-- Create Date:   19.11.2010
-- Design Name:   
-- Module Name:   FTU_test6_new_tb.vhd
-- Project Name:  
-- Target Device:  
-- Tool versions:  
-- Description:   Testbench for FTU RS485 test
-- 
-- VHDL Test Bench Created by ISE for module: FTU_test6_new
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use IEEE.NUMERIC_STD.ALL;

library UNISIM;
use UNISIM.VComponents.all;

entity FTU_test6_new_tb is
end FTU_test6_new_tb;

architecture behavior of FTU_test6_new_tb is 

  -- Component Declaration for the Unit Under Test (UUT)
 
  component FTU_test6_new
    port(
      ext_clk   : IN  STD_LOGIC;
      rx        : IN  STD_LOGIC;
      tx        : OUT STD_LOGIC;
      rx_en     : OUT STD_LOGIC;
      tx_en     : OUT STD_LOGIC;
      enables_A : OUT STD_LOGIC_VECTOR(8 downto 0);
      enables_B : OUT STD_LOGIC_VECTOR(8 downto 0);
      enables_C : OUT STD_LOGIC_VECTOR(8 downto 0);
      enables_D : OUT STD_LOGIC_VECTOR(8 downto 0)
    );
  end component;
    
  --Inputs
  signal clk : STD_LOGIC := '0';
  signal rx  : STD_LOGIC := '1';

  --Outputs
  signal enables_A : STD_LOGIC_VECTOR(8 downto 0);
  signal enables_B : STD_LOGIC_VECTOR(8 downto 0);
  signal enables_C : STD_LOGIC_VECTOR(8 downto 0);
  signal enables_D : STD_LOGIC_VECTOR(8 downto 0);
  signal tx        : STD_LOGIC;
  signal rx_en     : STD_LOGIC;
  signal tx_en     : STD_LOGIC;

  -- Clock period definitions
  constant clk_period : TIME := 20 ns;
  constant baud_rate_period : TIME := 4 us;
  
begin
 
  -- Instantiate the Unit Under Test (UUT)
  uut: FTU_test6_new
    port map(
      ext_clk   => clk,
      rx        => rx,
      tx        => tx,
      rx_en     => rx_en,
      tx_en     => tx_en,
      enables_A => enables_A,
      enables_B => enables_B,
      enables_C => enables_C,
      enables_D => enables_D
    );

  -- Stimulus process for clock
  clk_proc: process
  begin
    clk <= '0';
    wait for clk_period/2;
    clk <= '1';
    wait for clk_period/2;
  end process clk_proc;
 
  -- Stimulus process for RS485
  rs485_proc: process
    
    procedure assign_rs485 (data: std_logic_vector(7 downto 0)) is
    begin
      rx <= '0'; --start bit
      wait for baud_rate_period;
      rx <= data(0); --bit 0
      wait for baud_rate_period;
      rx <= data(1); --bit 1
      wait for baud_rate_period;
      rx <= data(2); --bit 2
      wait for baud_rate_period;
      rx <= data(3); --bit 3
      wait for baud_rate_period;
      rx <= data(4); --bit 4
      wait for baud_rate_period;
      rx <= data(5); --bit 5
      wait for baud_rate_period;
      rx <= data(6); --bit 6
      wait for baud_rate_period;
      rx <= data(7); --bit 7
      wait for baud_rate_period;
      rx <= '1'; --stop bit
      wait for baud_rate_period;
      rx <= '1'; --stop bit
      wait for baud_rate_period;
    end assign_rs485;
    
  begin
    wait for 1us;
    ---------------------------------------------------------------------------
    -- send a '1' character
    ---------------------------------------------------------------------------
    assign_rs485("00110001");
    wait for 1us;
    ---------------------------------------------------------------------------
    -- send a '2' character
    ---------------------------------------------------------------------------
    assign_rs485("00110010");
    wait for 1us;
    ---------------------------------------------------------------------------
    -- send a '3' character
    ---------------------------------------------------------------------------
    assign_rs485("00110011");
    wait for 1us;
    ---------------------------------------------------------------------------
    -- send a '4' character
    ---------------------------------------------------------------------------
    assign_rs485("00110100");
    wait for 1us;
    ---------------------------------------------------------------------------
    -- send a '0' character
    ---------------------------------------------------------------------------
    assign_rs485("00110000");
    wait for 1us;
    ---------------------------------------------------------------------------
    -- don't forget final wait!
    ---------------------------------------------------------------------------
    wait;
    
  end process rs485_proc;

end;
