--------------------------------------------------------------------------------
-- Company:       ETH Zurich, Institute for Particle Physics
-- Engineer:      Q. Weitzel, P. Vogler
--
-- Create Date:   16.11.2010
-- Design Name:   
-- Module Name:   FTM_test8_tb.vhd
-- Project Name:  
-- Target Device:  
-- Tool versions:  
-- Description:   Testbench for FTM RS485 test
-- 
-- VHDL Test Bench Created by ISE for module: FTM_test8
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
use IEEE.NUMERIC_STD.ALL;

library UNISIM;
use UNISIM.VComponents.all;

entity FTU_test8_tb is
end FTU_test8_tb;

architecture behavior of FTU_test8_tb is 

  -- Component Declaration for the Unit Under Test (UUT)
 
  component FTM_test8
    port(
      clk        : in  STD_LOGIC;
      LED_red    : out STD_LOGIC_VECTOR(3 downto 0);
      LED_ye     : out STD_LOGIC_VECTOR(1 downto 0);
      LED_gn     : out STD_LOGIC_VECTOR(1 downto 0);
      Bus1_Tx_En : out STD_LOGIC;
      Bus1_Rx_En : out STD_LOGIC;
      Bus1_RxD_0 : in STD_LOGIC;
      Bus1_TxD_0 : out STD_LOGIC
    );
  end component;
    
  --Inputs
  signal clk_sig        : STD_LOGIC := '0';
  signal Bus1_RxD_0_sig : STD_LOGIC := '1';

  --Outputs
  signal LED_red_sig    : STD_LOGIC_VECTOR(3 downto 0);
  signal LED_ye_sig     : STD_LOGIC_VECTOR(1 downto 0);
  signal LED_gn_sig     : STD_LOGIC_VECTOR(1 downto 0);
  signal Bus1_Tx_En_sig : STD_LOGIC;
  signal Bus1_Rx_En_sig : STD_LOGIC;
  signal Bus1_TxD_0_sig : STD_LOGIC;
  
  -- Clock period definitions
  constant clk_period : TIME := 25 ns;
  constant baud_rate_period : TIME := 4 us;
  
begin
 
  -- Instantiate the Unit Under Test (UUT)
  uut: FTM_test8
    port map(
      clk        => clk_sig,
      LED_red    => LED_red_sig,
      LED_ye     => LED_ye_sig,
      LED_gn     => LED_gn_sig,
      Bus1_Tx_En => Bus1_Tx_En_sig,
      Bus1_Rx_En => Bus1_Rx_En_sig,
      Bus1_RxD_0 => Bus1_RxD_0_sig,
      Bus1_TxD_0 => Bus1_TxD_0_sig
    );

  -- Stimulus process for clock
  clk_proc: process
  begin
    clk_sig <= '0';
    wait for clk_period/2;
    clk_sig <= '1';
    wait for clk_period/2;
  end process clk_proc;
 
  -- Stimulus process for RS485
  rs485_proc: process
    
    procedure assign_rs485 (data: std_logic_vector(7 downto 0)) is
    begin
      Bus1_RxD_0_sig <= '0'; --start bit
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(0); --bit 0
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(1); --bit 1
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(2); --bit 2
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(3); --bit 3
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(4); --bit 4
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(5); --bit 5
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(6); --bit 6
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= data(7); --bit 7
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= '1'; --stop bit
      wait for baud_rate_period;
      Bus1_RxD_0_sig <= '1'; --stop bit
      wait for baud_rate_period;
    end assign_rs485;
    
  begin
    wait for 1us;
    ---------------------------------------------------------------------------
    -- send a '1' character
    ---------------------------------------------------------------------------
    assign_rs485("00110001");
    wait for 1us;
    ---------------------------------------------------------------------------
    -- send a '2' character
    ---------------------------------------------------------------------------
    assign_rs485("00110010");
    wait for 1us;
    ---------------------------------------------------------------------------
    -- send a '3' character
    ---------------------------------------------------------------------------
    assign_rs485("00110011");
    wait for 1us;
    ---------------------------------------------------------------------------
    -- send a '4' character
    ---------------------------------------------------------------------------
    assign_rs485("00110100");
    wait for 1us;
    ---------------------------------------------------------------------------
    -- send a '0' character
    ---------------------------------------------------------------------------
    assign_rs485("00110000");
    wait for 1us;
    ---------------------------------------------------------------------------
    -- don't forget final wait!
    ---------------------------------------------------------------------------
    wait;
    
  end process rs485_proc;

end;
