#include "mars/MTime.h"

using namespace std;

/*
    // Culmination tests
    //{"0411",  "TPoints Residuals 11/2004" ,  "tpoint/tpoint0411.txt"},
    //{"+0412",  "TPoints Residuals 12/2004" ,  "tpoint/tpoint0412.txt"},

    // 1: Worse pointing due to realignment of the mirror
    {"0503",  "TPoints Residuals 3/2005" ,   "tpoint/tpoint0503.txt"},

    // New pointing model installed (29.4.2005)
    // MIRROR MISALIGNMENT (WHEN?)
    {"0504",  "TPoints Residuals 4/2005" ,   "tpoint/tpoint0504.txt"},
    {"+05051", "TPoints Residuals 5/2005-1" , "tpoint/tpoint0505-1.txt"},

    // 2: Mirror alignment has been fixed
    {"05052", "TPoints Residuals 5/2005-2" , "tpoint/tpoint0505-2.txt"},

    // Pointing model changed due to fixing a screw
    {"0506", "TPoints Residuals 6/2005" , "tpoint/tpoint0506.txt"},

    // New pointing model applied (7.-9.6.2005)
    {"0508", "TPoints Residuals 8/2005" , "tpoint/tpoint0508.txt"},

    // New pointing model applied (12.9.2005)
    {"0509", "TPoints Residuals 9/2005" , "tpoint/tpoint0509.txt"},
    // Quick-and-dirty mirror alignment (only 4 TPoints)
    {"+0510", "TPoints Residuals 10/2005" , "tpoint/tpoint0510.txt"},

    // 3: New mirror alignment after Tenerife meeting
    //{"05111", "TPoints Residuals 11/2005-1" , "tpoint/tpoint0511-1.txt"},

    // [...]
*/

Double_t dates[] = {
    /*
    MTime(2005,  3, 20).GetAxisTime(),
    MTime(2005,  4, 29).GetAxisTime(),
    MTime(2005,  5, 25).GetAxisTime(),
    MTime(2005,  6,  8).GetAxisTime(), // New pointing model
    MTime(2005,  8, 15).GetAxisTime(),
    //        MTime(2005,  9, 12).GetAxisTime(), // New pointing model
    MTime(2005, 11, 10).GetAxisTime(), // New mirror alignment after Tenerife meeting
    MTime(2005, 11, 24).GetAxisTime(), // New pointing model
    MTime(2006,  3, 19).GetAxisTime(), // Changes to the mirror
    //    2006,  4, 23                 // Mirror refocussing
    MTime(2006, 10, 17).GetAxisTime(), // New pointing model
    MTime(2007,  6, 17).GetAxisTime(), // New pointing model
    MTime(2007,  8,  4).GetAxisTime(), // Mirror refocussing
    MTime(2007, 10, 18).GetAxisTime(), // New pointing model
    MTime(2008,  1, 14).GetAxisTime(), // New pointing model
    MTime(2008,  6, 11).GetAxisTime(), // New pointing model
    MTime(2008,  6, 18).GetAxisTime(), // New pointing model
    //    2009,  3,  7                 // New pointing model
    //    2009,  5, 14                 // New pointing model
    */
    // Are we missing TPoints between 080618 and 090501??
    MTime(2009,  5,  1).GetAxisTime(), // Drive upgrade started
    MTime(2009,  5, 11).GetAxisTime(), // Upgrade finished
    MTime(2009,  5, 12).GetAxisTime(), // First new pointing model
    MTime(2009,  5, 13).GetAxisTime(), // Second new pointing model
    MTime(2009,  6, 11).GetAxisTime(), // Jump (reason unknown)
    MTime(2009,  7, 23).GetAxisTime(), // New LUTs
    MTime(2009,  8, 17).GetAxisTime(), // New pointing model
    MTime(2010, 02, 01).GetAxisTime(), // New pointing model
    //    2010, 02, 03                 // New LUTs for M2(!)
    MTime(2010, 02, 27).GetAxisTime(), // New pointing model
    MTime(2010, 03, 31).GetAxisTime(), // New pointing model
    //    2010, 06, 14                 // New LUTs
    MTime(2010, 07, 03).GetAxisTime(), // New LUTs
    MTime(2010,  9, 29).GetAxisTime(), // New pointing model
                                       // 18.11. New LUTs
    MTime(2010, 10, 24).GetAxisTime(), // A Change in Superarehucas (it was always focussed to the
                                       // position at which moving started, not where it ended
                                       // (This mainly affects the quality of the TPoints not the pointing model)
    MTime(-1).GetAxisTime(),
    -1
};

#include "plot.C"

void plot_m1()
{

    MDirIter Next;
    Next.AddDirectory("tpoint/m1", "tpoint*.txt", -1);

    plot(Next);
}
