#ifndef MMCTHREASHOLDCALC_H
#define MMCTHREASHOLDCALC_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MMcThresholdCalc                                                        //
//                                                                         //
// Compute the energy threshold from Monte Carlo data                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MTASK_h
#include "MTask.h"
#endif
#ifndef ROOT_TObjArray
#include "TObjArray.h"
#endif

class MMcEvt;
class MMcTrig;
class MHMcEnergy;

class MMcThresholdCalc : public MTask
{
private:
    UInt_t fFirst;
    UInt_t fLast;

    UInt_t fNum;

    const MMcEvt  *fMcEvt;       // Container with Monte Carlo information

    TObjArray    *fMcTrig;       // Container with Monte Carlo trigger information
    TObjArray    *fEnergy;       // Container where we save the energy (threshold)

    const static Float_t fSqrt2; // sqrt(2)

    MMcTrig    *GetTrig   (UInt_t i) { return (MMcTrig*)   (*fMcTrig)[i]; }
    MHMcEnergy *GetHEnergy(UInt_t i) { return (MHMcEnergy*)(*fEnergy)[i]; }

public:

    MMcThresholdCalc(const Int_t dim = 0,
                     const char* name = NULL, const char* title = NULL);
    ~MMcThresholdCalc();

    Bool_t PreProcess(MParList* pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MMcThresholdCalc, 0) // Task to compute the energy threshold
};

#endif



