--
-- VHDL Architecture FACT_FAD_lib.led_controller.bahavior
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 11:04:17 04.01.2011
--
-- using Mentor Graphics HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
use ieee.STD_LOGIC_UNSIGNED.all;

library FACT_FAD_lib;


use FACT_FAD_lib.fad_definitions.all;


ENTITY led_controller IS
GENERIC( 
  HEARTBEAT_PWM_DIVIDER : integer := 500;   -- 1kHz @ 50 MHz
  MAX_DELAY : integer := 100;
  WAITING_DIVIDER : integer := 500000000   -- 1Hz @ 50 MHz
);
PORT(
    CLK : IN std_logic;
    
    -- LED outs -- inverted logic
    green : OUT std_logic;
    amber : OUT std_logic; 
    red : OUT std_logic; 
    
    
    -- status INs
    trigger : IN std_logic; -- when trigger is received green should toggle
    
    socks_waiting : IN std_logic;
    socks_connected: IN std_logic
    
    --heartbeat_en : IN std_logic
  );
END ENTITY led_controller;

--
ARCHITECTURE bahavior OF led_controller IS
  
  type states is ( INIT, WAITING, CONNECTED); 
    signal state,next_state : states := INIT;
  
  -- noninverted logic
  signal green_loc : std_logic := '1';  -- on in order to show power
  signal amber_loc : std_logic := '0'; --default off
  signal red_loc  : std_logic := '0'; --default off
  signal flasher : std_logic;
  
BEGIN
  -- since leds have inverted logic, the outs are inverted at this point.
  green <= not green_loc;
  amber <= not amber_loc;
  red <= not red_loc;
  
  -- MAIN FSM: go to next state if rising edge
    FSM_Registers: process(CLK)
    begin
      if Rising_edge(CLK) then
        state <= next_state;
      end if;
    end process;

    -- MAIN FSM
    FSM_logic: process(state, socks_connected, socks_waiting)
    begin
      next_state <= state;
      case state is
    

      when INIT =>
        amber_loc <= '0';
      if (socks_waiting = '1') then
        next_state <= WAITING;
      else 
        next_state <= INIT;
      end if;

      when WAITING =>
        amber_loc <= flasher;
        if (socks_connected = '1') then
          next_state <= CONNECTED;
        else
          next_state <= WAITING;
        end if;

      when CONNECTED =>
        amber_loc <= '1';
        if (socks_connected = '0') then
          next_state <= INIT;
        else
          next_state <= CONNECTED;
        end if;
      end case;
    end process FSM_logic;


  -- if trigger is received green_loc toggles
  trigger_proc : process (trigger)
    begin
      if Rising_edge(trigger) then
        green_loc <= not green_loc;
      end if;
    end process trigger_proc;
    
  -- heartbeat process:
  -- as long as nothing else is to be done for the red led
  -- it will show a ~2Hz heartbeat
  -- can be switched off with heartbeat_en high
  heartbeat : process (CLK)
      variable Z: integer range 0 to HEARTBEAT_PWM_DIVIDER - 1 := 0;
      variable ON_TIME: integer range 0 to HEARTBEAT_PWM_DIVIDER - 1 := 0;
      variable DELAY: integer range 0 to MAX_DELAY - 1 := 0;
      variable DIR : std_logic := '1';
      
    begin
      if rising_edge(CLK) then
        if (Z < HEARTBEAT_PWM_DIVIDER - 1) then 
          Z := Z + 1;
        else 
          Z := 0;
          if (DELAY < MAX_DELAY - 1) then 
            DELAY := DELAY + 1;
          else 
            DELAY := 0;
          end if;
        end if;
        
        
        if (Z = 0) then
          if (DIR = '0') then -- count up
            if (ON_TIME < HEARTBEAT_PWM_DIVIDER - 11) then 
              ON_TIME := ON_TIME + 10;
            else 
              DIR := '1';
            end if;
          else -- DIR is '1' -- count down
            if (ON_TIME > 10) then 
              ON_TIME := ON_TIME - 10;
            else 
              DIR := '0';
            end if;
          end if;            
        end if;
        
        if (Z = 0) then 
          red_loc <= '1';  
        end if;
        if (Z = ON_TIME) then
          red_loc <= '0';
        end if;
      end if;
    end process heartbeat; 
    
    
      -- sock_waiting_flasher process:
      sock_waiting_flasher : process (CLK)
          variable Y: integer range 0 to WAITING_DIVIDER - 1;
        begin
          if rising_edge(CLK) then
            if (Y < WAITING_DIVIDER - 1) then 
              Y := Y + 1;
            else 
              Y := 0;
            end if;
            if (Y = 0) then 
              flasher <= '1';
            end if;
            if (Y = WAITING_DIVIDER / 2) then 
              flasher <= '0';
            end if;
          end if;
        end process sock_waiting_flasher; 
    
   
END ARCHITECTURE bahavior;

