-- VHDL Entity FACT_FAD_lib.FAD_Board.symbol
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 17:46:34 05.01.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY FAD_Board IS
   PORT( 
      A0_D       : IN     std_logic_vector (11 DOWNTO 0);
      A1_D       : IN     std_logic_vector (11 DOWNTO 0);
      A2_D       : IN     std_logic_vector (11 DOWNTO 0);
      A3_D       : IN     std_logic_vector (11 DOWNTO 0);
      A_OTR      : IN     std_logic_vector (3 DOWNTO 0);
      D0_SROUT   : IN     std_logic;
      D1_SROUT   : IN     std_logic;
      D2_SROUT   : IN     std_logic;
      D3_SROUT   : IN     std_logic;
      D_PLLLCK   : IN     std_logic_vector (3 DOWNTO 0);
      RS485_C_DI : IN     std_logic;
      RS485_E_DI : IN     std_logic;
      RS485_E_DO : IN     std_logic;
      TRG        : IN     STD_LOGIC;
      W_INT      : IN     std_logic;
      X_50M      : IN     STD_LOGIC;
      A0_T       : OUT    std_logic_vector (7 DOWNTO 0) := (others => '0');
      A1_T       : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      AMBER_LED  : OUT    std_logic;
      A_CLK      : OUT    std_logic_vector (3 DOWNTO 0);
      D0_SRCLK   : OUT    STD_LOGIC;
      D1_SRCLK   : OUT    STD_LOGIC;
      D2_SRCLK   : OUT    STD_LOGIC;
      D3_SRCLK   : OUT    STD_LOGIC;
      DAC_CS     : OUT    std_logic;
      DENABLE    : OUT    std_logic                     := '0';
      DWRITE     : OUT    std_logic                     := '0';
      D_A        : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      D_T        : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      D_T2       : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      EE_CS      : OUT    std_logic;
      GREEN_LED  : OUT    std_logic;
      MOSI       : OUT    std_logic                     := '0';
      OE_ADC     : OUT    STD_LOGIC;
      RED_LED    : OUT    std_logic;
      RS485_C_DE : OUT    std_logic;
      RS485_C_DO : OUT    std_logic;
      RS485_C_RE : OUT    std_logic;
      RS485_E_DE : OUT    std_logic;
      RS485_E_RE : OUT    std_logic;
      RSRLOAD    : OUT    std_logic                     := '0';
      SRIN       : OUT    std_logic                     := '0';
      S_CLK      : OUT    std_logic;
      T0_CS      : OUT    std_logic;
      T1_CS      : OUT    std_logic;
      T2_CS      : OUT    std_logic;
      T3_CS      : OUT    std_logic;
      TRG_V      : OUT    std_logic;
      W_A        : OUT    std_logic_vector (9 DOWNTO 0);
      W_CS       : OUT    std_logic                     := '1';
      W_RD       : OUT    std_logic                     := '1';
      W_RES      : OUT    std_logic                     := '1';
      W_WR       : OUT    std_logic                     := '1';
      MISO       : INOUT  std_logic;
      W_D        : INOUT  std_logic_vector (15 DOWNTO 0)
   );

-- Declarations

END FAD_Board ;

--
-- VHDL Architecture FACT_FAD_lib.FAD_Board.struct
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 17:46:35 05.01.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.NUMERIC_STD.all;
USE ieee.std_logic_unsigned.all;

LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

LIBRARY FACT_FAD_lib;

ARCHITECTURE struct OF FAD_Board IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL CLK25_OUT       : std_logic;
   SIGNAL CLK25_PSOUT     : std_logic;
   SIGNAL CLK50_OUT       : std_logic;
   SIGNAL CLK_25_PS       : std_logic;
   SIGNAL CLK_25_PS1      : std_logic;
   SIGNAL CLK_50          : std_logic;
   SIGNAL DCM_locked      : std_logic;
   SIGNAL LOCKED_extraOUT : std_logic;
   SIGNAL PSCLK_OUT       : std_logic;
   SIGNAL PSDONE_extraOUT : std_logic;
   SIGNAL PSEN_OUT        : std_logic;
   SIGNAL PSINCDEC_OUT    : std_logic;
   SIGNAL PS_DIR_IN       : std_logic;
   SIGNAL PS_DO_IN        : std_logic;
   SIGNAL SRCLK           : std_logic                    := '0';
   SIGNAL adc_clk_en      : std_logic                    := '0';
   SIGNAL adc_data_array  : adc_data_array_type;
   SIGNAL board_id        : std_logic_vector(3 DOWNTO 0);
   SIGNAL crate_id        : std_logic_vector(1 DOWNTO 0);
   SIGNAL drs_channel_id  : std_logic_vector(3 DOWNTO 0) := (others => '0');
   SIGNAL dummy           : std_logic;
   SIGNAL ready           : std_logic                    := '0';
   SIGNAL sensor_cs       : std_logic_vector(3 DOWNTO 0);
   -- status:
   SIGNAL shifting        : std_logic                    := '0';

   -- Implicit buffer signal declarations
   SIGNAL SRIN_internal : std_logic;


   -- Component Declarations
   COMPONENT FAD_main
   GENERIC (
      RAMADDRWIDTH64b : integer := 12
   );
   PORT (
      CLK             : IN     std_logic ;
      SROUT_in_0      : IN     std_logic ;
      SROUT_in_1      : IN     std_logic ;
      SROUT_in_2      : IN     std_logic ;
      SROUT_in_3      : IN     std_logic ;
      adc_data_array  : IN     adc_data_array_type ;
      adc_otr_array   : IN     std_logic_vector (3 DOWNTO 0);
      board_id        : IN     std_logic_vector (3 DOWNTO 0);
      crate_id        : IN     std_logic_vector (1 DOWNTO 0);
      trigger         : IN     std_logic ;
      wiz_int         : IN     std_logic ;
      CLK25_OUT       : OUT    std_logic ;
      CLK25_PSOUT     : OUT    std_logic ;
      CLK50_OUT       : OUT    std_logic ;
      CLK_25_PS       : OUT    std_logic ;
      CLK_50          : OUT    std_logic ;
      DCM_locked      : OUT    std_logic ;
      LOCKED_extraOUT : OUT    std_logic ;
      PSCLK_OUT       : OUT    std_logic ;
      PSDONE_extraOUT : OUT    std_logic ;
      PSEN_OUT        : OUT    std_logic ;
      PSINCDEC_OUT    : OUT    std_logic ;
      PS_DIR_IN       : OUT    std_logic ;
      PS_DO_IN        : OUT    std_logic ;
      RSRLOAD         : OUT    std_logic                     := '0';
      SRCLK           : OUT    std_logic                     := '0';
      SRIN_out        : OUT    std_logic                     := '0';
      adc_clk_en      : OUT    std_logic                     := '0';
      adc_oeb         : OUT    std_logic                     := '1';
      amber           : OUT    std_logic ;
      dac_cs          : OUT    std_logic ;
      denable         : OUT    std_logic                     := '0';           -- default domino wave off
      drs_channel_id  : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      drs_dwrite      : OUT    std_logic                     := '1';
      green           : OUT    std_logic ;
      led             : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      mosi            : OUT    std_logic                     := '0';
      offset          : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      ready           : OUT    std_logic                     := '0';
      red             : OUT    std_logic ;
      sclk            : OUT    std_logic ;
      sensor_cs       : OUT    std_logic_vector (3 DOWNTO 0);
      -- status:
      shifting        : OUT    std_logic                     := '0';
      wiz_addr        : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_cs          : OUT    std_logic                     := '1';
      wiz_rd          : OUT    std_logic                     := '1';
      wiz_reset       : OUT    std_logic                     := '1';
      wiz_wr          : OUT    std_logic                     := '1';
      sio             : INOUT  std_logic ;
      wiz_data        : INOUT  std_logic_vector (15 DOWNTO 0)
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : FAD_main USE ENTITY FACT_FAD_lib.FAD_main;
   -- pragma synthesis_on


BEGIN
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 1 eb_ID
   -- hard-wired IDs
   board_id <= "0101";
   crate_id <= "01";

   -- HDL Embedded Text Block 2 ADC_CLK
   -- ADC_CLK 2
   A_CLK (0) <= CLK_25_PS;
   A_CLK (1) <= CLK_25_PS;
   A_CLK (2) <= CLK_25_PS;
   A_CLK (3) <= CLK_25_PS;                                        

   -- HDL Embedded Text Block 3 ADC_DATA
   -- ADC_DATA 3 
   adc_data_array (0) <= A0_D;
   adc_data_array (1) <= A1_D;
   adc_data_array (2) <= A2_D;
   adc_data_array (3) <= A3_D;                                       

   -- HDL Embedded Text Block 4 SRCLK
   -- SRCLK 4         
   D0_SRCLK <= SRCLK;
   D1_SRCLK <= SRCLK;
   D2_SRCLK <= SRCLK;
   D3_SRCLK <= SRCLK;                               

   -- HDL Embedded Text Block 5 T_CS
   -- T_CS 5
   T0_CS <= sensor_cs (0); 
   T1_CS <= sensor_cs (1);
   T2_CS <= sensor_cs (2);
   T3_CS <= sensor_cs (3);                                      

   -- HDL Embedded Text Block 6 MISC
   -- MISC 6     
   TRG_V <= '0';
   RS485_C_RE <= '0'; 
   RS485_C_DE <= '0';   
   RS485_C_DO <= RS485_C_DI;
   
   RS485_E_RE <= '0';      
   RS485_E_DE <= '0'; 
   --RS485_E_DO <= RS485_E_DI;
   
   -- DENABLE <= '0'; -- domino wave stopped
   -- DENABLE <= '1'; -- domino wave running
   
   
   EE_CS <= '1';

   -- HDL Embedded Text Block 7 eb1
   D_T2 <= D_PLLLCK;

   -- HDL Embedded Text Block 8 eb2
   -- eb2 8                                        
   D_A <= drs_channel_id;

   -- HDL Embedded Text Block 9 eb3
   -- eb3 9                          
   A0_T(0) <= ready;
   A0_T(1) <= shifting;
   A0_T(2) <= CLK25_PSOUT;
   A0_T(3) <= PS_DIR_IN;
   A0_T(4) <= PS_DO_IN;
   A0_T(5) <= PSINCDEC_OUT;
   A0_T(6) <= PSEN_OUT;
   A0_T(7) <= DCM_locked;
   
   A1_T(0) <= SRIN_internal;
   A1_T(1) <= PSDONE_extraOUT;
   A1_T(2) <= PSCLK_OUT;
   A1_T(3) <= LOCKED_extraOUT;
   
   A1_T(4) <= drs_channel_id(0);
   A1_T(5) <= drs_channel_id(1);
   A1_T(6) <= drs_channel_id(2);
   A1_T(7) <= drs_channel_id(3);


   -- ModuleWare code(v1.9) for instance 'I0' of 'and'
   CLK_25_PS <= adc_clk_en AND CLK_25_PS1;

   -- ModuleWare code(v1.9) for instance 'I3' of 'assignment'
   DAC_CS <= dummy;

   -- Instance port mappings.
   I_board_main : FAD_main
      GENERIC MAP (
         RAMADDRWIDTH64b => LOG2_OF_RAM_SIZE_64B
      )
      PORT MAP (
         CLK             => X_50M,
         SROUT_in_0      => D0_SROUT,
         SROUT_in_1      => D1_SROUT,
         SROUT_in_2      => D2_SROUT,
         SROUT_in_3      => D3_SROUT,
         adc_data_array  => adc_data_array,
         adc_otr_array   => A_OTR,
         board_id        => board_id,
         crate_id        => crate_id,
         trigger         => TRG,
         wiz_int         => W_INT,
         CLK25_OUT       => CLK25_OUT,
         CLK25_PSOUT     => CLK25_PSOUT,
         CLK50_OUT       => CLK50_OUT,
         CLK_25_PS       => CLK_25_PS1,
         CLK_50          => CLK_50,
         DCM_locked      => DCM_locked,
         LOCKED_extraOUT => LOCKED_extraOUT,
         PSCLK_OUT       => PSCLK_OUT,
         PSDONE_extraOUT => PSDONE_extraOUT,
         PSEN_OUT        => PSEN_OUT,
         PSINCDEC_OUT    => PSINCDEC_OUT,
         PS_DIR_IN       => PS_DIR_IN,
         PS_DO_IN        => PS_DO_IN,
         RSRLOAD         => RSRLOAD,
         SRCLK           => SRCLK,
         SRIN_out        => SRIN_internal,
         adc_clk_en      => adc_clk_en,
         adc_oeb         => OE_ADC,
         amber           => AMBER_LED,
         dac_cs          => dummy,
         denable         => DENABLE,
         drs_channel_id  => drs_channel_id,
         drs_dwrite      => DWRITE,
         green           => RED_LED,
         led             => D_T,
         mosi            => MOSI,
         offset          => OPEN,
         ready           => ready,
         red             => GREEN_LED,
         sclk            => S_CLK,
         sensor_cs       => sensor_cs,
         shifting        => shifting,
         wiz_addr        => W_A,
         wiz_cs          => W_CS,
         wiz_rd          => W_RD,
         wiz_reset       => W_RES,
         wiz_wr          => W_WR,
         sio             => MISO,
         wiz_data        => W_D
      );

   -- Implicit buffered output assignments
   SRIN <= SRIN_internal;

END struct;
