-- VHDL Entity FACT_FAD_lib.FAD_main.symbol
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 17:46:33 05.01.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

ENTITY FAD_main IS
   GENERIC( 
      RAMADDRWIDTH64b : integer := 12
   );
   PORT( 
      CLK             : IN     std_logic;
      SROUT_in_0      : IN     std_logic;
      SROUT_in_1      : IN     std_logic;
      SROUT_in_2      : IN     std_logic;
      SROUT_in_3      : IN     std_logic;
      adc_data_array  : IN     adc_data_array_type;
      adc_otr_array   : IN     std_logic_vector (3 DOWNTO 0);
      board_id        : IN     std_logic_vector (3 DOWNTO 0);
      crate_id        : IN     std_logic_vector (1 DOWNTO 0);
      trigger         : IN     std_logic;
      wiz_int         : IN     std_logic;
      CLK25_OUT       : OUT    std_logic;
      CLK25_PSOUT     : OUT    std_logic;
      CLK50_OUT       : OUT    std_logic;
      CLK_25_PS       : OUT    std_logic;
      CLK_50          : OUT    std_logic;
      DCM_locked      : OUT    std_logic;
      LOCKED_extraOUT : OUT    std_logic;
      PSCLK_OUT       : OUT    std_logic;
      PSDONE_extraOUT : OUT    std_logic;
      PSEN_OUT        : OUT    std_logic;
      PSINCDEC_OUT    : OUT    std_logic;
      PS_DIR_IN       : OUT    std_logic;
      PS_DO_IN        : OUT    std_logic;
      RSRLOAD         : OUT    std_logic                     := '0';
      SRCLK           : OUT    std_logic                     := '0';
      SRIN_out        : OUT    std_logic                     := '0';
      adc_clk_en      : OUT    std_logic                     := '0';
      adc_oeb         : OUT    std_logic                     := '1';
      amber           : OUT    std_logic;
      dac_cs          : OUT    std_logic;
      denable         : OUT    std_logic                     := '0';              -- default domino wave off
      drs_channel_id  : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      drs_dwrite      : OUT    std_logic                     := '1';
      green           : OUT    std_logic;
      led             : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      mosi            : OUT    std_logic                     := '0';
      offset          : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      ready           : OUT    std_logic                     := '0';
      red             : OUT    std_logic;
      sclk            : OUT    std_logic;
      sensor_cs       : OUT    std_logic_vector (3 DOWNTO 0);
      -- status:
      shifting        : OUT    std_logic                     := '0';
      wiz_addr        : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_cs          : OUT    std_logic                     := '1';
      wiz_rd          : OUT    std_logic                     := '1';
      wiz_reset       : OUT    std_logic                     := '1';
      wiz_wr          : OUT    std_logic                     := '1';
      sio             : INOUT  std_logic;
      wiz_data        : INOUT  std_logic_vector (15 DOWNTO 0)
   );

-- Declarations

END FAD_main ;

--
-- VHDL Architecture FACT_FAD_lib.FAD_main.struct
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 17:46:34 05.01.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
library ieee;
use ieee.std_logic_1164.all;
use IEEE.STD_LOGIC_ARITH.all;
use ieee.STD_LOGIC_UNSIGNED.all;

library fact_fad_lib;
use fact_fad_lib.fad_definitions.all;

library UNISIM;
use UNISIM.VComponents.all;
USE IEEE.NUMERIC_STD.all;
USE IEEE.std_logic_signed.all;

LIBRARY FACT_FAD_lib;

ARCHITECTURE struct OF FAD_main IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL CLK_25                 : std_logic;
   SIGNAL SRCLK1                 : std_logic                                    := '0';
   SIGNAL adc_data_array_int     : adc_data_array_type;
   SIGNAL adc_otr                : std_logic_vector(3 DOWNTO 0);
   SIGNAL addr_out               : std_logic_vector(RAMADDRWIDTH64b-1 DOWNTO 0);
   SIGNAL config_addr            : std_logic_vector(7 DOWNTO 0);
   SIGNAL config_busy            : std_logic;
   SIGNAL config_data            : std_logic_vector(15 DOWNTO 0);
   SIGNAL config_data_valid      : std_logic;
   SIGNAL config_rd_en           : std_logic;
   SIGNAL config_ready           : std_logic;
   SIGNAL config_ready_cm        : std_logic;
   SIGNAL config_ready_spi       : std_logic;
   -- --
   SIGNAL config_rw_ack          : std_logic                                    := '0';
   -- --
   SIGNAL config_rw_ready        : std_logic                                    := '0';
   SIGNAL config_start           : std_logic                                    := '0';
   SIGNAL config_start_cm        : std_logic;
   SIGNAL config_start_spi       : std_logic                                    := '0';
   SIGNAL config_started         : std_logic;
   SIGNAL config_started_cu      : std_logic                                    := '0';
   SIGNAL config_started_mm      : std_logic;
   SIGNAL config_started_spi     : std_logic                                    := '0';
   SIGNAL config_wr_en           : std_logic;
   SIGNAL dac_array              : dac_array_type;
   SIGNAL data_out               : std_logic_vector(63 DOWNTO 0);
   SIGNAL drs_address            : std_logic_vector(3 DOWNTO 0)                 := (others => '0');
   SIGNAL drs_address_mode       : std_logic;
   SIGNAL drs_channel_internal   : std_logic_vector(3 DOWNTO 0)                 := (others => '0');
   SIGNAL drs_clk_en             : std_logic                                    := '0';
   SIGNAL drs_read_s_cell        : std_logic                                    := '0';
   SIGNAL drs_read_s_cell_ready  : std_logic;
   SIGNAL drs_readout_started    : std_logic;
   SIGNAL drs_s_cell_array       : drs_s_cell_array_type;
   SIGNAL drs_srin_data          : std_logic_vector(7 DOWNTO 0)                 := (others => '0');
   SIGNAL dwrite                 : std_logic                                    := '1';
   SIGNAL dwrite_enable          : std_logic                                    := '1';
   SIGNAL new_config             : std_logic                                    := '0';
   SIGNAL package_length         : std_logic_vector(15 DOWNTO 0);
   SIGNAL ps_direction           : std_logic                                    := '1';                -- default phase shift upwards
   SIGNAL ps_do_phase_shift      : std_logic                                    := '0';                --pulse this to phase shift once
   SIGNAL ps_reset               : std_logic                                    := '0';                -- pulse this to reset the variable phase shift
   SIGNAL ram_addr               : std_logic_vector(RAMADDRWIDTH64b+1 DOWNTO 0);
   SIGNAL ram_data               : std_logic_vector(15 DOWNTO 0);
   SIGNAL ram_start_addr         : std_logic_vector(RAMADDRWIDTH64b-1 DOWNTO 0);
   SIGNAL ram_write_ea           : std_logic;
   SIGNAL ram_write_ready        : std_logic                                    := '0';
   -- --
   SIGNAL ram_write_ready_ack    : std_logic                                    := '0';
   SIGNAL roi_array              : roi_array_type;
   SIGNAL roi_max                : roi_max_type;
   SIGNAL s_trigger              : std_logic;
   SIGNAL sclk1                  : std_logic;
   SIGNAL sclk_enable            : std_logic;
   SIGNAL sensor_array           : sensor_array_type;
   SIGNAL sensor_ready           : std_logic;
   SIGNAL socks_connected        : std_logic;
   SIGNAL socks_waiting          : std_logic;
   SIGNAL srclk_enable           : std_logic                                    := '0';
   SIGNAL srin_write_ack         : std_logic                                    := '0';
   SIGNAL srin_write_ready       : std_logic                                    := '0';
   SIGNAL start_srin_write_8b    : std_logic;
   SIGNAL trigger_id             : std_logic_vector(47 DOWNTO 0);
   SIGNAL trigger_out            : std_logic;
   SIGNAL wiz_ack                : std_logic;
   SIGNAL wiz_busy               : std_logic;
   SIGNAL wiz_number_of_channels : std_logic_vector(3 DOWNTO 0)                 := (others => '0');
   SIGNAL wiz_ram_start_addr     : std_logic_vector(RAMADDRWIDTH64b+1 DOWNTO 0) := (others => '0');
   SIGNAL wiz_write_ea           : std_logic                                    := '0';
   SIGNAL wiz_write_end          : std_logic                                    := '0';
   SIGNAL wiz_write_header       : std_logic                                    := '0';
   SIGNAL wiz_write_length       : std_logic_vector(16 DOWNTO 0)                := (others => '0');
   SIGNAL write_ea               : std_logic_vector(0 DOWNTO 0)                 := "0";

   -- Implicit buffer signal declarations
   SIGNAL CLK_25_PS_internal : std_logic;
   SIGNAL CLK_50_internal    : std_logic;


   -- Component Declarations
   COMPONENT adc_buffer
   PORT (
      adc_data_array     : IN     adc_data_array_type;
      adc_otr_array      : IN     std_logic_vector (3 DOWNTO 0);
      clk_ps             : IN     std_logic;
      adc_data_array_int : OUT    adc_data_array_type;
      adc_otr            : OUT    std_logic_vector (3 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT clock_generator_var_ps
   PORT (
      CLK             : IN     std_logic ;
      RST_IN          : IN     std_logic ;
      direction       : IN     std_logic ;
      do_shift        : IN     std_logic ;
      CLK_25          : OUT    std_logic ;
      CLK_25_PS       : OUT    std_logic ;
      CLK_50          : OUT    std_logic ;
      DCM_locked      : OUT    std_logic ;
      LOCKED_extraOUT : OUT    std_logic ;
      PSCLK_OUT       : OUT    std_logic ;
      PSDONE_extraOUT : OUT    std_logic ;
      PSEN_OUT        : OUT    std_logic ;
      PSINCDEC_OUT    : OUT    std_logic ;
      offset          : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      ready           : OUT    std_logic                     := '0';
      -- status:
      shifting        : OUT    std_logic                     := '0'
   );
   END COMPONENT;
   COMPONENT control_unit
   PORT (
      clk               : IN     STD_LOGIC ;
      config_addr       : IN     std_logic_vector (7 DOWNTO 0);
      config_rd_en      : IN     std_logic ;
      config_start      : IN     std_logic ;
      config_wr_en      : IN     std_logic ;
      config_busy       : OUT    std_logic ;
      config_data_valid : OUT    std_logic ;
      config_ready      : OUT    std_logic ;
      -- --
      config_rw_ack     : OUT    std_logic  := '0';
      -- --
      config_rw_ready   : OUT    std_logic  := '0';
      config_started    : OUT    std_logic  := '0';
      dac_array         : OUT    dac_array_type ;
      roi_array         : OUT    roi_array_type ;
      config_data       : INOUT  std_logic_vector (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT dataRAM_64b_16b_width14_5
   PORT (
      clka  : IN     std_logic ;
      dina  : IN     std_logic_VECTOR (63 DOWNTO 0);
      addra : IN     std_logic_VECTOR (14 DOWNTO 0);
      wea   : IN     std_logic_VECTOR (0 DOWNTO 0);
      clkb  : IN     std_logic ;
      addrb : IN     std_logic_VECTOR (16 DOWNTO 0);
      doutb : OUT    std_logic_VECTOR (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT data_generator
   GENERIC (
      RAM_ADDR_WIDTH : integer := 12
   );
   PORT (
      --      led            : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      clk                   : IN     std_logic ;
      data_out              : OUT    std_logic_vector (63 DOWNTO 0);
      addr_out              : OUT    std_logic_vector (RAM_ADDR_WIDTH-1 DOWNTO 0);
      write_ea              : OUT    std_logic_vector (0 DOWNTO 0) := "0";
      ram_start_addr        : IN     std_logic_vector (RAM_ADDR_WIDTH-1 DOWNTO 0);
      ram_write_ea          : IN     std_logic ;
      ram_write_ready       : OUT    std_logic                     := '0';
      -- --
      ram_write_ready_ack   : IN     std_logic ;
      -- --
      config_start_mm       : OUT    std_logic                     := '0';
      -- --
      config_start_cm       : OUT    std_logic                     := '0';
      -- --
      config_start_spi      : OUT    std_logic                     := '0';
      config_ready_mm       : IN     std_logic ;
      config_ready_cm       : IN     std_logic ;
      config_ready_spi      : IN     std_logic ;
      config_started_mm     : IN     std_logic ;
      config_started_cm     : IN     std_logic ;
      config_started_spi    : IN     std_logic ;
      roi_array             : IN     roi_array_type ;
      roi_max               : IN     roi_max_type ;
      sensor_array          : IN     sensor_array_type ;
      sensor_ready          : IN     std_logic ;
      dac_array             : IN     dac_array_type ;
      package_length        : IN     std_logic_vector (15 DOWNTO 0);
      board_id              : IN     std_logic_vector (3 DOWNTO 0);
      crate_id              : IN     std_logic_vector (1 DOWNTO 0);
      trigger_id            : IN     std_logic_vector (47 DOWNTO 0);
      trigger               : IN     std_logic ;
      --      s_trigger      : in std_logic;
      new_config            : IN     std_logic ;
      config_started        : OUT    std_logic                     := '0';
      adc_data_array        : IN     adc_data_array_type ;
      adc_oeb               : OUT    std_logic                     := '1';
      adc_clk_en            : OUT    std_logic                     := '0';
      adc_otr               : IN     std_logic_vector (3 DOWNTO 0);
      drs_channel_id        : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      drs_dwrite            : OUT    std_logic                     := '1';
      drs_clk_en            : OUT    std_logic                     := '0';
      drs_read_s_cell       : OUT    std_logic                     := '0';
      drs_srin_write_8b     : OUT    std_logic                     := '0';
      drs_srin_write_ack    : IN     std_logic ;
      drs_srin_data         : OUT    std_logic_vector (7 DOWNTO 0) := (others => '0');
      drs_srin_write_ready  : IN     std_logic ;
      drs_read_s_cell_ready : IN     std_logic ;
      drs_s_cell_array      : IN     drs_s_cell_array_type ;
      drs_readout_started   : OUT    std_logic 
   );
   END COMPONENT;
   COMPONENT drs_pulser
   PORT (
      CLK                      : IN     std_logic;
      SROUT_in_0               : IN     std_logic;
      SROUT_in_1               : IN     std_logic;
      SROUT_in_2               : IN     std_logic;
      SROUT_in_3               : IN     std_logic;
      srin_data                : IN     std_logic_vector (7 DOWNTO 0);
      start_endless_mode       : IN     std_logic;
      start_read_stop_pos_mode : IN     std_logic;
      start_srin_write_8b      : IN     std_logic;
      RSRLOAD                  : OUT    std_logic  := '0';
      SRCLK                    : OUT    std_logic  := '0';
      SRIN_out                 : OUT    std_logic  := '0';
      srin_write_ack           : OUT    std_logic  := '0';
      srin_write_ready         : OUT    std_logic  := '0';
      stop_pos                 : OUT    drs_s_cell_array_type;
      stop_pos_valid           : OUT    std_logic  := '0'
   );
   END COMPONENT;
   COMPONENT led_controller
   GENERIC (
      HEARTBEAT_PWM_DIVIDER : integer := 500;           -- 1kHz @ 50 MHz
      MAX_DELAY             : integer := 100;
      WAITING_DIVIDER       : integer := 500000000      -- 1Hz @ 50 MHz
   );
   PORT (
      CLK             : IN     std_logic;
      socks_connected : IN     std_logic;
      socks_waiting   : IN     std_logic;
      trigger         : IN     std_logic;
      amber           : OUT    std_logic;
      green           : OUT    std_logic;
      red             : OUT    std_logic
   );
   END COMPONENT;
   COMPONENT memory_manager
   GENERIC (
      RAM_ADDR_WIDTH_64B : integer := 12;
      RAM_ADDR_WIDTH_16B : integer := 14
   );
   PORT (
      clk                    : IN     std_logic ;
      config_start           : IN     std_logic ;
      ram_write_ready        : IN     std_logic ;
      -- --
      ram_write_ready_ack    : OUT    std_logic                                        := '0';
      -- --
      roi_array              : IN     roi_array_type ;
      ram_write_ea           : OUT    std_logic                                        := '0';
      config_ready           : OUT    std_logic                                        := '0';
      config_started         : OUT    std_logic                                        := '0';
      roi_max                : OUT    roi_max_type                                     := (others => conv_std_logic_vector (0, 11));
      package_length         : OUT    std_logic_vector (15 DOWNTO 0)                   := (others => '0');
      wiz_ram_start_addr     : OUT    std_logic_vector (RAM_ADDR_WIDTH_16B-1 DOWNTO 0) := (others => '0');
      wiz_write_length       : OUT    std_logic_vector (16 DOWNTO 0)                   := (others => '0');
      wiz_number_of_channels : OUT    std_logic_vector (3 DOWNTO 0)                    := (others => '0');
      wiz_write_ea           : OUT    std_logic                                        := '0';
      wiz_write_header       : OUT    std_logic                                        := '0';
      wiz_write_end          : OUT    std_logic                                        := '0';
      wiz_busy               : IN     std_logic ;
      wiz_ack                : IN     std_logic ;
      ram_start_addr         : OUT    std_logic_vector (RAM_ADDR_WIDTH_64B-1 DOWNTO 0) := (others => '0')
   );
   END COMPONENT;
   COMPONENT spi_interface
   PORT (
      clk_50MHz      : IN     std_logic ;
      config_start   : IN     std_logic ;
      dac_array      : IN     dac_array_type ;
      config_ready   : OUT    std_logic ;
      config_started : OUT    std_logic  := '0';
      dac_cs         : OUT    std_logic ;
      mosi           : OUT    std_logic  := '0';
      sclk           : OUT    std_logic ;
      sensor_array   : OUT    sensor_array_type ;
      sensor_cs      : OUT    std_logic_vector (3 DOWNTO 0);
      sensor_ready   : OUT    std_logic ;
      miso           : INOUT  std_logic 
   );
   END COMPONENT;
   COMPONENT trigger_counter
   PORT (
      trigger_id : OUT    std_logic_vector (47 DOWNTO 0);
      trigger    : IN     std_logic ;
      clk        : IN     std_logic 
   );
   END COMPONENT;
   COMPONENT w5300_modul
   GENERIC (
      RAM_ADDR_WIDTH : integer := 14
   );
   PORT (
      clk               : IN     std_logic ;
      wiz_reset         : OUT    std_logic                      := '1';
      addr              : OUT    std_logic_vector (9 DOWNTO 0);
      data              : INOUT  std_logic_vector (15 DOWNTO 0);
      cs                : OUT    std_logic                      := '1';
      wr                : OUT    std_logic                      := '1';
      led               : OUT    std_logic_vector (7 DOWNTO 0)  := (OTHERS => '0');
      rd                : OUT    std_logic                      := '1';
      int               : IN     std_logic ;
      write_length      : IN     std_logic_vector (16 DOWNTO 0);
      ram_start_addr    : IN     std_logic_vector (RAM_ADDR_WIDTH-1 DOWNTO 0);
      ram_data          : IN     std_logic_vector (15 DOWNTO 0);
      ram_addr          : OUT    std_logic_vector (RAM_ADDR_WIDTH-1 DOWNTO 0);
      data_valid        : IN     std_logic ;
      data_valid_ack    : OUT    std_logic                      := '0';
      busy              : OUT    std_logic                      := '1';
      write_header_flag : IN     std_logic ;
      write_end_flag    : IN     std_logic ;
      fifo_channels     : IN     std_logic_vector (3 DOWNTO 0);
      s_trigger         : OUT    std_logic                      := '0';
      new_config        : OUT    std_logic                      := '0';
      config_started    : IN     std_logic ;
      config_addr       : OUT    std_logic_vector (7 DOWNTO 0);
      config_data       : INOUT  std_logic_vector (15 DOWNTO 0) := (others => 'Z');
      config_wr_en      : OUT    std_logic                      := '0';
      config_rd_en      : OUT    std_logic                      := '0';
      -- --
      config_rw_ack     : IN     std_logic ;
      -- --
      config_rw_ready   : IN     std_logic ;
      -- --
      config_busy       : IN     std_logic ;
      denable           : OUT    std_logic                      := '0';           -- default domino wave off
      dwrite_enable     : OUT    std_logic                      := '0';           -- default DWRITE low.
      sclk_enable       : OUT    std_logic                      := '1';           -- default DWRITE HIGH.
      ps_direction      : OUT    std_logic                      := '1';           -- default phase shift upwards
      ps_do_phase_shift : OUT    std_logic                      := '0';           --pulse this TO phase shift once
      ps_reset          : OUT    std_logic                      := '0';           -- pulse this TO reset the variable phase shift
      srclk_enable      : OUT    std_logic                      := '1';           -- default SRCLK on.
      socks_waiting     : OUT    std_logic ;
      socks_connected   : OUT    std_logic 
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : adc_buffer USE ENTITY FACT_FAD_lib.adc_buffer;
   FOR ALL : clock_generator_var_ps USE ENTITY FACT_FAD_lib.clock_generator_var_ps;
   FOR ALL : control_unit USE ENTITY FACT_FAD_lib.control_unit;
   FOR ALL : dataRAM_64b_16b_width14_5 USE ENTITY FACT_FAD_lib.dataRAM_64b_16b_width14_5;
   FOR ALL : data_generator USE ENTITY FACT_FAD_lib.data_generator;
   FOR ALL : drs_pulser USE ENTITY FACT_FAD_lib.drs_pulser;
   FOR ALL : led_controller USE ENTITY FACT_FAD_lib.led_controller;
   FOR ALL : memory_manager USE ENTITY FACT_FAD_lib.memory_manager;
   FOR ALL : spi_interface USE ENTITY FACT_FAD_lib.spi_interface;
   FOR ALL : trigger_counter USE ENTITY FACT_FAD_lib.trigger_counter;
   FOR ALL : w5300_modul USE ENTITY FACT_FAD_lib.w5300_modul;
   -- pragma synthesis_on


BEGIN

   -- ModuleWare code(v1.9) for instance 'I5' of 'and'
   drs_dwrite <= dwrite AND dwrite_enable;

   -- ModuleWare code(v1.9) for instance 'I6' of 'and'
   SRCLK <= SRCLK1 AND srclk_enable;

   -- ModuleWare code(v1.9) for instance 'U_1' of 'and'
   sclk <= sclk_enable AND sclk1;

   -- ModuleWare code(v1.9) for instance 'U_3' of 'assignment'
   PS_DO_IN <= ps_do_phase_shift;

   -- ModuleWare code(v1.9) for instance 'U_5' of 'assignment'
   PS_DIR_IN <= ps_direction;

   -- ModuleWare code(v1.9) for instance 'U_6' of 'assignment'
   CLK50_OUT <= CLK_50_internal;

   -- ModuleWare code(v1.9) for instance 'U_7' of 'assignment'
   CLK25_OUT <= CLK_25;

   -- ModuleWare code(v1.9) for instance 'U_8' of 'assignment'
   CLK25_PSOUT <= CLK_25_PS_internal;

   -- ModuleWare code(v1.9) for instance 'U_0' of 'mux'
   u_0combo_proc: PROCESS(drs_channel_internal, drs_address, 
                          drs_address_mode)
   BEGIN
      CASE drs_address_mode IS
      WHEN '0' => drs_channel_id <= drs_channel_internal;
      WHEN '1' => drs_channel_id <= drs_address;
      WHEN OTHERS => drs_channel_id <= (OTHERS => 'X');
      END CASE;
   END PROCESS u_0combo_proc;

   -- ModuleWare code(v1.9) for instance 'U_9' of 'or'
   trigger_out <= s_trigger OR trigger;

   -- Instance port mappings.
   I_main_adc_buffer : adc_buffer
      PORT MAP (
         clk_ps             => CLK_25_PS_internal,
         adc_data_array     => adc_data_array,
         adc_otr_array      => adc_otr_array,
         adc_data_array_int => adc_data_array_int,
         adc_otr            => adc_otr
      );
   U_2 : clock_generator_var_ps
      PORT MAP (
         CLK             => CLK,
         RST_IN          => ps_reset,
         direction       => ps_direction,
         do_shift        => ps_do_phase_shift,
         CLK_25          => CLK_25,
         CLK_25_PS       => CLK_25_PS_internal,
         CLK_50          => CLK_50_internal,
         DCM_locked      => DCM_locked,
         LOCKED_extraOUT => LOCKED_extraOUT,
         PSCLK_OUT       => PSCLK_OUT,
         PSDONE_extraOUT => PSDONE_extraOUT,
         PSEN_OUT        => PSEN_OUT,
         PSINCDEC_OUT    => PSINCDEC_OUT,
         offset          => offset,
         ready           => ready,
         shifting        => shifting
      );
   I_main_control_unit : control_unit
      PORT MAP (
         clk               => CLK_50_internal,
         config_addr       => config_addr,
         config_rd_en      => config_rd_en,
         config_start      => config_start_cm,
         config_wr_en      => config_wr_en,
         config_busy       => config_busy,
         config_data_valid => config_data_valid,
         config_ready      => config_ready_cm,
         config_rw_ack     => config_rw_ack,
         config_rw_ready   => config_rw_ready,
         config_started    => config_started_cu,
         dac_array         => dac_array,
         roi_array         => roi_array,
         config_data       => config_data
      );
   U_4 : dataRAM_64b_16b_width14_5
      PORT MAP (
         clka  => CLK_25,
         dina  => data_out,
         addra => addr_out,
         wea   => write_ea,
         clkb  => CLK_50_internal,
         addrb => ram_addr,
         doutb => ram_data
      );
   I_main_data_generator : data_generator
      GENERIC MAP (
         RAM_ADDR_WIDTH => RAMADDRWIDTH64b
      )
      PORT MAP (
         clk                   => CLK_25,
         data_out              => data_out,
         addr_out              => addr_out,
         write_ea              => write_ea,
         ram_start_addr        => ram_start_addr,
         ram_write_ea          => ram_write_ea,
         ram_write_ready       => ram_write_ready,
         ram_write_ready_ack   => ram_write_ready_ack,
         config_start_mm       => config_start,
         config_start_cm       => config_start_cm,
         config_start_spi      => config_start_spi,
         config_ready_mm       => config_ready,
         config_ready_cm       => config_ready_cm,
         config_ready_spi      => config_ready_spi,
         config_started_mm     => config_started_mm,
         config_started_cm     => config_started_cu,
         config_started_spi    => config_started_spi,
         roi_array             => roi_array,
         roi_max               => roi_max,
         sensor_array          => sensor_array,
         sensor_ready          => sensor_ready,
         dac_array             => dac_array,
         package_length        => package_length,
         board_id              => board_id,
         crate_id              => crate_id,
         trigger_id            => trigger_id,
         trigger               => trigger_out,
         new_config            => new_config,
         config_started        => config_started,
         adc_data_array        => adc_data_array_int,
         adc_oeb               => adc_oeb,
         adc_clk_en            => adc_clk_en,
         adc_otr               => adc_otr,
         drs_channel_id        => drs_channel_internal,
         drs_dwrite            => dwrite,
         drs_clk_en            => drs_clk_en,
         drs_read_s_cell       => drs_read_s_cell,
         drs_srin_write_8b     => start_srin_write_8b,
         drs_srin_write_ack    => srin_write_ack,
         drs_srin_data         => drs_srin_data,
         drs_srin_write_ready  => srin_write_ready,
         drs_read_s_cell_ready => drs_read_s_cell_ready,
         drs_s_cell_array      => drs_s_cell_array,
         drs_readout_started   => drs_readout_started
      );
   I_main_drs_pulser : drs_pulser
      PORT MAP (
         CLK                      => CLK_25,
         start_endless_mode       => drs_clk_en,
         start_read_stop_pos_mode => drs_read_s_cell,
         SROUT_in_0               => SROUT_in_0,
         SROUT_in_1               => SROUT_in_1,
         SROUT_in_2               => SROUT_in_2,
         SROUT_in_3               => SROUT_in_3,
         stop_pos                 => drs_s_cell_array,
         stop_pos_valid           => drs_read_s_cell_ready,
         start_srin_write_8b      => start_srin_write_8b,
         srin_write_ready         => srin_write_ready,
         srin_write_ack           => srin_write_ack,
         srin_data                => drs_srin_data,
         SRIN_out                 => SRIN_out,
         RSRLOAD                  => RSRLOAD,
         SRCLK                    => SRCLK1
      );
   U_10 : led_controller
      GENERIC MAP (
         HEARTBEAT_PWM_DIVIDER => 50000,           -- 10kHz @ 50 MHz
         MAX_DELAY             => 100,
         WAITING_DIVIDER       => 50000000         -- 1Hz @ 50 MHz
      )
      PORT MAP (
         CLK             => CLK_50_internal,
         green           => green,
         amber           => amber,
         red             => red,
         trigger         => drs_readout_started,
         socks_waiting   => socks_waiting,
         socks_connected => socks_connected
      );
   I_main_memory_manager : memory_manager
      GENERIC MAP (
         RAM_ADDR_WIDTH_64B => RAMADDRWIDTH64b,
         RAM_ADDR_WIDTH_16B => RAMADDRWIDTH64b+2
      )
      PORT MAP (
         clk                    => CLK_25,
         config_start           => config_start,
         ram_write_ready        => ram_write_ready,
         ram_write_ready_ack    => ram_write_ready_ack,
         roi_array              => roi_array,
         ram_write_ea           => ram_write_ea,
         config_ready           => config_ready,
         config_started         => config_started_mm,
         roi_max                => roi_max,
         package_length         => package_length,
         wiz_ram_start_addr     => wiz_ram_start_addr,
         wiz_write_length       => wiz_write_length,
         wiz_number_of_channels => wiz_number_of_channels,
         wiz_write_ea           => wiz_write_ea,
         wiz_write_header       => wiz_write_header,
         wiz_write_end          => wiz_write_end,
         wiz_busy               => wiz_busy,
         wiz_ack                => wiz_ack,
         ram_start_addr         => ram_start_addr
      );
   I_main_SPI_interface : spi_interface
      PORT MAP (
         clk_50MHz      => CLK_50_internal,
         config_start   => config_start_spi,
         dac_array      => dac_array,
         config_ready   => config_ready_spi,
         config_started => config_started_spi,
         dac_cs         => dac_cs,
         mosi           => mosi,
         sclk           => sclk1,
         sensor_array   => sensor_array,
         sensor_cs      => sensor_cs,
         sensor_ready   => sensor_ready,
         miso           => sio
      );
   I_main_ext_trigger : trigger_counter
      PORT MAP (
         trigger_id => trigger_id,
         trigger    => trigger_out,
         clk        => CLK_25_PS_internal
      );
   I_main_ethernet : w5300_modul
      GENERIC MAP (
         RAM_ADDR_WIDTH => RAMADDRWIDTH64b+2
      )
      PORT MAP (
         clk               => CLK_50_internal,
         wiz_reset         => wiz_reset,
         addr              => wiz_addr,
         data              => wiz_data,
         cs                => wiz_cs,
         wr                => wiz_wr,
         led               => led,
         rd                => wiz_rd,
         int               => wiz_int,
         write_length      => wiz_write_length,
         ram_start_addr    => wiz_ram_start_addr,
         ram_data          => ram_data,
         ram_addr          => ram_addr,
         data_valid        => wiz_write_ea,
         data_valid_ack    => wiz_ack,
         busy              => wiz_busy,
         write_header_flag => wiz_write_header,
         write_end_flag    => wiz_write_end,
         fifo_channels     => wiz_number_of_channels,
         s_trigger         => s_trigger,
         new_config        => new_config,
         config_started    => config_started,
         config_addr       => config_addr,
         config_data       => config_data,
         config_wr_en      => config_wr_en,
         config_rd_en      => config_rd_en,
         config_rw_ack     => config_rw_ack,
         config_rw_ready   => config_rw_ready,
         config_busy       => config_busy,
         denable           => denable,
         dwrite_enable     => dwrite_enable,
         sclk_enable       => sclk_enable,
         ps_direction      => ps_direction,
         ps_do_phase_shift => ps_do_phase_shift,
         ps_reset          => ps_reset,
         srclk_enable      => srclk_enable,
         socks_waiting     => socks_waiting,
         socks_connected   => socks_connected
      );

   -- Implicit buffered output assignments
   CLK_25_PS <= CLK_25_PS_internal;
   CLK_50    <= CLK_50_internal;

END struct;
