//-----------------------------------------------------------------------------
#include "typedefs.h"
#include "application.h"
#include "spare_outs.h"
#include "spi_master.h"
#include "ad7719_adc.h"    
#include "usart.h"
#include "macros.h"
#include "interpol.h"
#include "w5100_spi_interface.h"
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <stdlib.h>

#include "tests.h"
//-----------------------------------------------------------------------------

int main(void)
{
// U08 IDN_STR[] = "16ch Pt1000 logger; firmware version of 07.11.10. DN"; // Identity string

	spare_outs_init(); //set spare out pin I/O modes
  app_init();		  // Setup software modules
  usart_init();		// Initialize serial interface   
	spi_init(); 		// Initialize SPI interface as master
	adc_init(); 		// Initialize AD7719 ADC as SPI slave 
	//  usart_write_crlf();
	//  usart_writeln_flash_str(IDN_STR); // Write string to USART interface
	//  usart_write_crlf();

  //  Enable interrupts
  sei();              
 

	// temperature muxer pins init:
	// SA - pins
	DDRA |= 0x3F; // set all SA-pins as outputs
	

	// voltage, current, humidity - muxer pins:
	// SB - pins
	DDRB |= 0x7F; // set all SB - pins as outputs
	
	// SB - muxer test
	DDRA |= 1<<PA6 ; // set D0-0 lina as output. for tests only !!!
	PORTA |= 1<<PA6; // set D0-0 line high. for tests only !!!



// Main loop
//float temperature;
float resistance;
BOOL heartbeat_enable = TRUE;

U08 SA_mux_val = 0;
//U08 SB_mx_val = 0;
while (TRUE)
	 {
	 	// this heartbeat shows how long one single run of this while loop takes
		// measure with a scope.
		if (heartbeat_enable) PORTB ^= (1<<PB3); // toggle Out2_spare --> heartbeat

		// if USART data arrives. i.e. data via USB
		// the usart_rx_ready flag is set TRUE
		// now process the incoming data which is stored in 
		// U08 usart_rx_buffer[USART_RX_BUFFER_SIZE]
		// and tell the USART interface, it may receive new data
		// by setting the usart_rx_ready flag FALSE again
		++SA_mux_val;
		PORTA |= (SA_mux_val & 0x3F); 
		
		usart_write_str((pU08)"\tSA:");
		usart_write_U08(SA_mux_val,2);
		usart_write_str((pU08)"\t");
		_delay_us(200);
		
				
				if(ADC_IS_READY()) 
	    	{		
		   		startconv();							//Start a new A/D Conversion
		    	//temp = 	readandsendtemp();
					//adcword = getadc();
					resistance = getresistance();
					//temperature = gettemp();
					usart_write_str((pU08)"R:");
					usart_write_float(resistance,3,4);
					usart_write_str((pU08)"\t");	
				}
				if(ADC_IS_READY()) 
	    	{		
		   		startconv();							//Start a new A/D Conversion
		    	//temp = 	readandsendtemp();
					//adcword = getadc();
					resistance = getresistance();
					//temperature = gettemp();
					usart_write_str((pU08)"R:");
					usart_write_float(resistance,3,4);
					usart_write_str((pU08)"\n");	
				}

		
	/*	
		if ( usart_rx_ready == TRUE )
		{
			//understand what it means and react
			
			switch (usart_rx_buffer[0])
			{
				
				case 'h':
				{
					// toggle the heartbeat mode on or off.
					heartbeat_enable = !heartbeat_enable;
					break;
				}
				case 'a':
				{
					// conduct adc - AD7719 SPI interface test
					
					break;
				}
				case 'e':
				{
					// conduct ethernet module SPI interface test
					strtol((char*) usart_rx_buffer+1, NULL, 0);
					break;
				}

				default:
				{
					usart_write_str((pU08)"? you wrote: ");
					usart_write_str((pU08)usart_rx_buffer);
					usart_write_str((pU08)"\n");
					break;
				}
			}
			
			heartbeat_enable = !heartbeat_enable;
			usart_rx_ready = FALSE;
		}
*/
// das ist ein paar schritte zu frh.
// erstmal mssen die interfaces getestet werden.
/*

		for (U08 i = 0; i<16; i++)
	  	{ 
			
	   		if((~PIND) & 0x08)  // PD4 is #ADC_RDY input. Inverted logic! if PD4=0 this evaluates to true					
	    	{		
				PORTA = (PORTA & 0xF0) | ((i) & 0x0F); 	// switch muxer
		   		startconv();							//Start a new A/D Conversion
		    	//temp = 	readandsendtemp();
				//adcword = getadc();
				//resistance = getresistance();
				temperature = gettemp();
				usart_write_float(temperature,2,4);
				usart_write_str((pU08)"\t");

			} // end of if adc ready
			else
			{
			i--;
			}
		} // end of for loop over 16 channels
		usart_write_crlf();

*/

 	}	// end of infinite while loop
} // end of main()



