//-----------------------------------------------------------------------------

#include "application.h"
 #include <avr/wdt.h> 


//-----------------------------------------------------------------------------

volatile U08 app_reset_source;
//-----------------------------------------------------------------------------

void app_init(void)
{
  app_reset_source = MCUSR; // Save last reset source
  MCUSR = 0x00; // Clear reset source for next reset cycle

  // The watchdog timer is disabled by default ("startup.asm")
#ifdef USE_WATCHDOG
 WDTCSR = WDTOE | (1 << WDE); // Enable watchdog reset (~16ms)
#endif
  
#ifndef F_CPU
#define F_CPU 8000000UL	//cpu frequency
#endif

//#ifdef (F_CPU == 16000000UL)
/*#else
  #warning *** Compiling for _MCU_CLOCK_FREQUENCY_ Hz
  #error *** Invalid clock selected! ***
#endif*/
 // Tell the user the operating frequency
//#warning *** Compiling for DF_CPU Hz
/*
  // Set selected CPU clock
#if (_MCU_CLOCK_FREQUENCY_ == 16000000)
  CLKPR = CLKPCE; // Enable clock prescaler by writing 0x80 to CLKPR
  CLKPR = 0; // Set clock prescaler to division by 1 (16MHz clock with 16MHz crystal)
#elif (_MCU_CLOCK_FREQUENCY_ == 8000000)
  CLKPR = CLKPCE; // Enable clock prescaler by writing 0x80 to CLKPR
  CLKPR = 1; // Set clock prescaler to division by 2 (8MHz clock with 16MHz crystal)
#elif (_MCU_CLOCK_FREQUENCY_ == 4000000)
  CLKPR = CLKPCE; // Enable clock prescaler by writing 0x80 to CLKPR
  CLKPR = 2; // Set clock prescaler to division by 4 (4MHz clock with 16MHz crystal)
#elif (_MCU_CLOCK_FREQUENCY_ == 2000000)
  CLKPR = CLKPCE; // Enable clock prescaler by writing 0x80 to CLKPR
  CLKPR = 3; // Set clock prescaler to division by 8 (2MHz clock with 16MHz crystal)
#elif (_MCU_CLOCK_FREQUENCY_ == 1000000)
  CLKPR = CLKPCE; // Enable clock prescaler by writing 0x80 to CLKPR
  CLKPR = 4; // Set clock prescaler to division by 16 (1MHz clock with 16MHz crystal)
#else
  #warning *** Compiling for _MCU_CLOCK_FREQUENCY_ Hz
  #error *** Invalid clock selected! ***
#endif

  // Tell the user the operating frequency
#warning *** Compiling for _MCU_CLOCK_FREQUENCY_ Hz

*/ 

/* (ATmega32 has no prescaler)
  // Set selected CPU clock
#if (F_CPU == 16000000)
  CLKPR = CLKPCE; // Enable clock prescaler by writing 0x80 to CLKPR
  CLKPR = 0; // Set clock prescaler to division by 1 (16MHz clock with 16MHz crystal)
#elif (F_CPU == 8000000)
  CLKPR = CLKPCE; // Enable clock prescaler by writing 0x80 to CLKPR
  CLKPR = 1; // Set clock prescaler to division by 2 (8MHz clock with 16MHz crystal)
#elif (F_CPU == 4000000)
  CLKPR = CLKPCE; // Enable clock prescaler by writing 0x80 to CLKPR
  CLKPR = 2; // Set clock prescaler to division by 4 (4MHz clock with 16MHz crystal)
#elif (F_CPU == 2000000)
  CLKPR = CLKPCE; // Enable clock prescaler by writing 0x80 to CLKPR
  CLKPR = 3; // Set clock prescaler to division by 8 (2MHz clock with 16MHz crystal)
#elif (F_CPU == 1000000)
  CLKPR = CLKPCE; // Enable clock prescaler by writing 0x80 to CLKPR
  CLKPR = 4; // Set clock prescaler to division by 16 (1MHz clock with 16MHz crystal)
#else
  #warning *** Compiling for F_CPU Hz
  #error *** Invalid clock selected! ***
#endif



  // Tell the user the operating frequency
#warning *** Compiling for F_CPU Hz

 
  // Turn off unused modules for this application
  PRR =
  (
#ifndef USE_TWI
    TWEN // I2C module
  #warning *** Module "TWI" not enabled!
#endif

 (ATmega32 Can't disable TIMER modules)
#ifndef USE_TIMER2
    | PRTIM2 // Timer2
  #warning *** Module "TIMER2" not enabled!
#endif
#ifndef USE_TIMER1
    | PRTIM1 // Timer1
  #warning *** Module "TIMER1" not enabled!
#endif
#ifndef USE_TIMER0
    | PRTIM0 // Timer0
  #warning *** Module "TIMER0" not enabled!
#endif

#ifndef USE_USART0
    | PRUSART0 // USART0
  #warning *** Module "USART0" not enabled!
#endif

#ifndef USE_SPI
    | SPE // SPI
  #warning *** Module "SPI" not enabled!
#endif

#ifndef USE_ADC
    | ADEN // ADC
  #warning *** Module "ADC" not enabled!
#endif
  );

#ifndef USE_ACO // Analog comparator
  ACSR = ACME;
  #warning *** Module "ACO" not enabled!
#endif

  PORTC |= PC6; // Enable pullup for PC6_RESET

  // Initialize switches S1, S2 and S3
  //S1_INIT(); // Set S1 pin to input
  //S2_INIT(); // Set S2 pin to input
  //S3_INIT(); // Set S3 pin to input
*/
}



//-----------------------------------------------------------------------------

void app_set_watchdog_prescaler(tWDT_PRESCALE wdt_prescale) // Set watchdog prescale
{
  U08 sreg_backup = SREG; // Copy status register to variable
  U08 wdtcsr_value = WDE + wdt_prescale; // Set new prescale value to variable

  cli(); // Disable interrups
  wdt_reset(); // Reset watchdog

  WDTCR |= (1 << WDTOE) | (1 << WDE); // Unlock register access, 4 cycles to store new value
  WDTCR = wdtcsr_value; // Set new watchdog prescaler
  SREG = sreg_backup; // Restore status register
}
