#ifndef __APPLICATION_H
#define __APPLICATION_H
//-----------------------------------------------------------------------------

#include "typedefs.h"
//-----------------------------------------------------------------------------

//#define F_CPU (_MCU_CLOCK_FREQUENCY_)
#define F_CPU_KHZ (F_CPU / 1000)
#define F_CPU_MHZ (F_CPU_KHZ / 1000)
//-----------------------------------------------------------------------------

// Definitions of hardware modules used by application
// Comment out all unused hardware modules

//#define USE_TWI // I2C module used?
//#define USE_TIMER2 // Timer2 used?
//#define USE_TIMER1 // Timer1 used?
//#define USE_TIMER0 // Timer0 used?
//#define USE_SPI // SPI used?
//#define USE_USART // USART0 used?
//#define USE_ADC // ADC used?
//#define USE_ACO // Analog Comparator used?
//#define USE_WATCHDOG // Comment out to disable watchdog timer
//-----------------------------------------------------------------------------

// USART0 definitions
#define USART_RX_BUFFER_SIZE 64 // Receive buffer size

#define USART_BAUDRATE 38400 // USART baudrate original

#define USART_USE_TX // Transmitter used?
#define USART_USE_RX // Receiver used?
#define USART_USE_RX_IRQ // RX interrupt used?
#define USART_USE_UPPERCASE // Convert received chars to uppercase?
//-----------------------------------------------------------------------------

extern volatile U08 app_reset_source;
//-----------------------------------------------------------------------------

void app_init(void); // Initialize application
void app_set_watchdog_prescaler(tWDT_PRESCALE wdt_prescale); // Set watchdog prescale
//-----------------------------------------------------------------------------

#endif
