//-----------------------------------------------------------------------------

#include "interpol.h"
#include "usart.h"
#include "ad7719_adc.h" 
//#include "typedefs.h"
//#include "application.h"
#include "num_conversion.h"
//-----------------------------------------------------------------------------
/*
Temperatur Sensoren von IST nach DIN60751, Kl.B 
Messfehler +/- 0.30+0.005*|t|

R(t) = R0(1 + At + Bt^2 + C(t-100)t^3)  t = [-200, 0]C
R(t) = R0(1 + At + Bt^2)				t = [0, 850]C

A = 3.9083*10^-3[C^-1]
B = -5.775*10^-7[C^-2]
C = -4.183*10^-12[C^-4]

Strom durch R ist konstant 400uA
Intervallweise lineare Interpolation der Funktion R(t) mit MATLAB polyfit
adcword = 13107200 * u(temperatur)
*/
 U08 space_STR[] = "  |";
 U08 OoR_STR[] = "  OoR  |";



 float gettemp(void)
 {

  
  U8  temprange = 17;
  U32 adcword=0;
  float temp=-3.14; // should be initialized in a proper way, but I dont know how :-)
  const U32 min = 0x404054;
  const U32 max = 0x8CAF50;
  const U32 s	= 0x4C6F0;		//(max-min)/16 = s(lice)
  	
  adcword = read_adc();

 if  (adcword >= (min + 8*s))
   {
     if  (adcword >= (min + 12*s))
	   {
	     if  (adcword >= (min + 14*s))
		   {
			 if   (adcword >= (min + 15*s)) 
			   { 
			     if (adcword < max)
				   {
		            temprange = 16;
				   }
			   }
			 else
			   {
				 temprange = 15;
			   }
		   }
		 else
		   {
		      if  (adcword >= (min + 13*s))
			    {
				  temprange = 14;
				}
			  else
			    {
				  temprange = 13;
				}
		   }   
	   }
	 else
	   {
	     if  (adcword >= (min + 10*s))
		   {
			 if  (adcword >= (min + 11*s))
			   {
				 temprange = 12;
			   }
			 else
			   {
				 temprange = 11;
			   }
		   }
		 else
		   {
		      if  (adcword >= (min + 9*s))
			    {
				  temprange = 10;
				}
			  else
			    {
				  temprange = 9;
				}
		   }   
	   }
   } 
 else
 {
     if  (adcword >= (min + 4*s))
	   {
	     if  (adcword >= (min + 6*s))
		   {
			 if  (adcword >= (min + 7*s))
			   {
				 temprange = 8;
			   }
			 else
			   {
				 temprange = 7;
			   }
		   }
		 else
		   {
		      if  (adcword >= (min + 5*s))
			    {
				  temprange = 6;
				}
			  else
			    {
				  temprange = 5;
				}
		   }   
	   }
	 else
	   {
	     if  (adcword >= (min + 2*s))
		   {
			 if  (adcword >= (min + 3*s))
			   {
				 temprange = 4;
			   }
			 else
			   {
				 temprange = 3;
			   }
		   }
		 else
		   {
		      if  (adcword >= (min + s))
			    {
				  temprange = 2;
				}
			  else
			    { 
				  if  (adcword > min)
				    {
				      temprange = 1;
 					}
				}
		   }   
	   }
   } 


 switch (temprange)
  {
    case 1:{ // Temp. Range [-50C , -34.375C[
      temp = ((float)adcword / 20764.727846 - 252.7721); 		//20764.727846 - 252.7721
	  }
    break;

    case 2:{ // Temp. Range [-34.375C , -18.75C[
      temp = ((float)adcword / 20658.049789 - 253.8995);		//20658.049789 - 253.8995
	  }
    break;

    case 3:{ // Temp. Range [-18.75C , -3.125C[		
      temp = ((float)adcword / 20557.997603 - 255.0436);		//20557.997603 - 255.0436
	  }
    break;

    case 4:{ // Temp. Range [-3.125C , 12.5C]
      temp = ((float)adcword / 20462.362624 - 256.2209); 		//20462.362624 - 256.2209
	  }
    break;

    case 5:{ // Temp. Range [12.5C , 28.125C]
      temp = ((float)adcword / 20367.745024 - 257.4692);		//20367.745024 - 257.4692
	  }
    break;
	
    case 6:{ // Temp. Range [28.125C , 43.75C]
      temp = ((float)adcword / 20273.127424 - 258.8021);		//20273.127424 - 258.8021
	  }
    break;
	
    case 7:{ // Temp. Range [43.75C , 59.375C]
      temp = ((float)adcword / 20178.509824 - 260.2208);		//20178.509824 - 260.2208
	  }
    break;
	
    case 8:{ // Temp. Range [59.375C , 75C]
      temp = ((float)adcword / 20083.892224 - 261.7265);		//20083.892224 - 261.7265
	  }
    break;
	
    case 9:{ // Temp. Range [75C , 90.625C]
      temp = ((float)adcword / 19989.274624 - 263.3203);		//19989.274624 - 263.3203
	  }
    break;
	
    case 10:{ // Temp. Range [90.625C , 106.25C]
      temp = ((float)adcword / 19894.657024 - 265.0037);		//19894.657024 - 265.0037
	  }
    break;
	
    case 11:{ // Temp. Range [106.25C , 121.875C]
      temp = ((float)adcword / 19800.039424 - 266.7778);		//19800.039424 - 266.7778
	  }
    break;
	
    case 12:{ // Temp. Range [121.875C , 137.5C]
      temp = ((float)adcword / 19705.421824 - 268.6439);		//19705.421824 - 268.6439
	  }
    break;
	
    case 13:{ // Temp. Range [137.5C , 153.125C]
      temp = ((float)adcword / 19610.804224 - 270.6035);		//19610.804224 - 270.6035
	  }
    break;
	
    case 14:{ // Temp. Range [153.125C , 168.75C]
      temp = ((float)adcword / 19516.186624 - 272.6578);		//19516.186624 - 272.6578
	  }
    break;
	
    case 15:{ // Temp. Range [168.75C , 184.375C]
      temp = ((float)adcword / 19421.569024 - 274.8082);		//19421.569024 - 274.8082
	  }
    break;
	
    case 16:{ // Temp. Range [184.375C , 200C]
      temp = ((float)adcword / 19326.951424 - 277.0562);		//19326.951424 - 277.0562
	  }
    break;
    default:{ // Temp. Range beyond [-50C , 200C]
	  PORTC = (PORTC | 0x04);
	  }
  }// end of switch case statement
  return temp;

 }

 void readandsendpress(void)
 {
  U32 adcword=0;
  float press;

  adcword = read_adc();

 if ( (adcword > 0x253332) && (adcword < 0xF80000) ) // Press. Range is [0Bar , 250Bar]
   {
    press = ((float)adcword / (62 * 836.658790402)) - 63.0091; // 62 Ohm
	usart_write_float(press,2,5);
	usart_write_flash_str(space_STR);
   } 
 else
   {
	usart_write_flash_str(OoR_STR);  // Press. is beyond [0Bar , 250Bar]
    PORTC = (PORTC | 0x04);
   }

 }


/*
Temperatur Sensoren von IST nach DIN60751, Kl.B 
Messfehler +/- 0.30+0.005*|t|

R(t) = R0(1 + At + Bt^2 + C(t-100)t^3)  t = [-200, 0]C
R(t) = R0(1 + At + Bt^2)				t = [0, 850]C

A = 3.9083*10^-3[C^-1]
B = -5.775*10^-7[C^-2]
C = -4.183*10^-12[C^-4]

Strom durch R ist konstant 400uA
Messung ist ratiometrisch bezogen auf Referenzwiderstand an ADC Pin5 (REFIN-) und Pin6 (REFIN+)
Referenzwiderstand ist ca. 6.28kOhm.
ADC hat internes gain von 2.

*/

float getresistance(void)
{
  
  U32 adcword=0;
  float resistance;
  const float R_REF=6.28; // kilo-ohms	
  adcword = read_adc();
  U32 fullscale = 16777215L; //2^24 -1
  
  resistance = ((float)adcword / (float)fullscale) /2.0 * R_REF; // divide through 2.0 because of PGA in ADC.

  return resistance; // in kilo-ohms
}

U32 getadc(void) 
{
return read_adc();
}
