#ifndef __NUM_CONVERSION_H
#define __NUM_CONVERSION_H
//-----------------------------------------------------------------------------

#include "typedefs.h"
//-----------------------------------------------------------------------------

#define NC_BUFFER_LENGTH 16 // Conversion buffer size
#define NC_FILL_CHAR 32 // Character for post digits
//-----------------------------------------------------------------------------

extern U08 nc_buffer[];
//-----------------------------------------------------------------------------

pU08 nc_format(pU08 source_ptr,U08 digits);
pU08 nc_U08_to_str(U8 value,U08 digits);
pU08 nc_S08_to_str(S08 signed_value,U08 digits);
pU08 nc_U08_to_hex(U08 value);
pU08 nc_U08_to_bin(U08 value);
pU08 nc_U16_to_str(U16 value,U08 digits);
pU08 nc_S16_to_str(S16 signed_value,U08 digits);
pU08 nc_U16_to_hex(U16 value);
pU08 nc_U32_to_str(U32 value,U08 digits);
pU08 nc_S32_to_str(S32 signed_value,U08 digits);
pU08 nc_U32_to_hex(U32 value);
pU08 nc_float_to_str(float value,U08 decimals,U08 digits);
//-----------------------------------------------------------------------------

#endif
