//-----------------------------------------------------------------------------

#include "usart.h"

#include <avr/interrupt.h>
//-----------------------------------------------------------------------------

#ifdef USART_USE_RX_IRQ
  U08 usart_rx_buffer[USART_RX_BUFFER_SIZE];
  //U08 *usart_rx_buffer_ptr = &usart_rx_buffer[0];
  U08 usart_received_chars;
  volatile BOOL usart_rx_ready = false;
  static U08 usart_rx_buffer_index = 0;
  static U08 usart_receive_char;
  static BOOL usart_receive_suspended = false;
  volatile BOOL ISR_toggle_out = false;
#endif
//-----------------------------------------------------------------------------

void usart_init(void)
{
  USART_SET_BAUDRATE(USART_BAUDRATE);

  UCSRA = 0x00;

  UCSRB = 0x00; // Disable receiver and transmitter and interrupts

#ifdef USART_USE_RX
  UCSRB |= (1 << RXEN);			// Turn on receiver
	DDRD &= ~(1<<PD0);				// PD0 is RXD
#endif

#ifdef USART_USE_RX_IRQ
  UCSRB |= (1 << RXCIE);		// Enable rx interrupt
#endif

#ifdef USART_USE_TX
  UCSRB |= (1 << TXEN);			// Turn on transmitter
	DDRD |= 1<<PD1; 					// PD1 is TXD
#endif

  UCSRC = (1 << URSEL) | (1 << UCSZ1) | (1 << UCSZ0); // 8-Bit character length
}
//-----------------------------------------------------------------------------

void usart_write_char(U08 data)
{
  while (!(UCSRA & (1 << UDRE))) ; // Wait until tx register is empty

  UDR = data;
}
//-----------------------------------------------------------------------------

void usart_write_crlf(void)
{
  usart_write_char(USART_CHAR_CR);
  usart_write_char(USART_CHAR_LF);
}
//-----------------------------------------------------------------------------

void usart_write_str(pU08 str)
{
  while (*str)
  {
    usart_write_char(*str++);
  }
}
//-----------------------------------------------------------------------------

void usart_write_flash_str(fpU08 str)
{
  while (*str)
  {
    usart_write_char(*str++);
  }
}
//-----------------------------------------------------------------------------

void usart_writeln_flash_str(fpU08 str)
{
  while (*str)
  {
    usart_write_char(*str++);
  }

  usart_write_char(USART_CHAR_CR);
  usart_write_char(USART_CHAR_LF);
}
//-----------------------------------------------------------------------------

void usart_writeln_str(pU08 str)
{
  usart_write_str(str);
  usart_write_char(USART_CHAR_CR);
  usart_write_char(USART_CHAR_LF);
}
//-----------------------------------------------------------------------------

void usart_write_U08(U08 value,U08 digits)
{
  usart_write_str(nc_U08_to_str(value,digits));
}
//-----------------------------------------------------------------------------

void usart_write_S08(S08 value,U08 digits)
{
  usart_write_str(nc_S08_to_str(value,digits));
}
//-----------------------------------------------------------------------------

void usart_write_U08_hex(U08 value)
{
  usart_write_str(nc_U08_to_hex(value));
}
//-----------------------------------------------------------------------------

void usart_write_U08_bin(U08 value)
{
  usart_write_str(nc_U08_to_bin(value));
}
//-----------------------------------------------------------------------------

void usart_write_U16(U16 value,U08 digits)
{
  usart_write_str(nc_U16_to_str(value,digits));
}
//-----------------------------------------------------------------------------

void usart_write_S16(S16 value,U08 digits)
{
  usart_write_str(nc_S16_to_str(value,digits));
}
//-----------------------------------------------------------------------------

void usart_write_U16_hex(U16 value)
{
  usart_write_str(nc_U16_to_hex(value));
}
//-----------------------------------------------------------------------------

void usart_write_U32(U32 value,U08 digits)
{
  usart_write_str(nc_U32_to_str(value,digits));
}
//-----------------------------------------------------------------------------

void usart_write_S32(S32 value,U08 digits)
{
  usart_write_str(nc_S32_to_str(value,digits));
}
//-----------------------------------------------------------------------------

void usart_write_U32_hex(U32 value)
{
  usart_write_str(nc_U32_to_hex(value));
}
//-----------------------------------------------------------------------------

void usart_write_float(float value,U08 decimals,U08 digits)
{
  usart_write_str(nc_float_to_str(value,decimals,digits));
}
//-----------------------------------------------------------------------------

#ifdef USART_USE_RX_IRQ

ISR(SIG_USART_RECV)
{
	if (ISR_toggle_out) PORTB ^= (1<<PB3); // toggle Out2_spare when starting ISR

  usart_receive_char = UDR;

  if (usart_rx_ready) // Exit if ready flag is still set 
  {
    return;
  }

  // If CR received, then set ready flag
  if (usart_receive_char == USART_CHAR_CR)
  {
    usart_rx_buffer[usart_rx_buffer_index] = 0; // Terminate input string
    usart_received_chars = usart_rx_buffer_index;
    usart_rx_buffer_index = 0;
    usart_receive_suspended = false;
    usart_rx_ready = TRUE;
    return;
  }

  // Ignore all characters till next CR
  if (usart_receive_suspended)
  {
    return;
  }

  // Check for underscore or comment
  if (usart_receive_char == '_' || usart_receive_char == ';')
  {
    usart_receive_suspended = true;

    return;
  }

  // If Backspace received, then delete last character
  if (usart_receive_char == USART_CHAR_BS && usart_rx_buffer_index)
  {
    usart_rx_buffer_index--;

    return;
  }

  // Ignore invalid characters
  if (usart_receive_char < USART_CHAR_SPC)
  {
    return;
  }

#ifdef USART_USE_UPPERCASE
  if (usart_receive_char >= 'a' && usart_receive_char <= 'z')
  {
    usart_receive_char -= 32;
  }
#endif

  if (usart_rx_buffer_index < USART_RX_BUFFER_SIZE - 1) // Store character
  {
    usart_rx_buffer[usart_rx_buffer_index++] = usart_receive_char;
    usart_writeln_str(usart_rx_buffer);
  }
#endif 
  //usart_write_char(usart_rx_buffer[usart_rx_buffer_index]);
 //usart_writeln_str(usart_rx_buffer);
 //usart_write_char(usart_rx_buffer[1,2]);
 //usart_write_char(usart_rx_buffer[usart_rx_buffer_index]);
 //usart_writeln_flash_str(*usart_rx_buffer);
 //usart_write_char(usart_rx_buffer);
}  

/*
#define uart_maxstrlen 64
 
volatile U8 uart_str_complete=0;
volatile U8 uart_str_count=0;
volatile U8 uart_string[uart_maxstrlen+1]="";

ISR(USART_RXC_vect)
{
    unsigned char buffer = 64;
    // Daten aus dem Puffer lesen
    buffer = UDR;
	UDR = buffer;
	if ( uart_str_complete==0 ){	// wenn uart_string gerade in Verwendung, neues Zeichen verwerfen
		// Daten werden erst in string geschrieben, wenn nicht String-Ende/max Zeichenlnge erreicht ist/string gerade verarbeitet wird
	  	if (buffer!='\n' && buffer!='\r' && uart_str_count<uart_maxstrlen-1){
			uart_string[uart_str_count]=buffer;
			uart_str_count++;
		} else {
			uart_string[uart_str_count]='\0';
			uart_str_count=0;
			uart_str_complete=1;
		}
	}
}

*/
