//-----------------------------------------------------------------------------
#include "typedefs.h"
#include "application.h"
#include "spare_outs.h"
#include "spi_master.h"
#include "ad7719_adc.h"    
#include "usart.h"
#include "macros.h"
#include "interpol.h"
#include "w5100_spi_interface.h"
#include <avr/interrupt.h>
#include <avr/wdt.h>
#include <stdlib.h>

#include "tests.h"
//-----------------------------------------------------------------------------

int main(void)
{
// U08 IDN_STR[] = "16ch Pt1000 logger; firmware version of 07.11.10. DN"; // Identity string

	spare_outs_init(); //set spare out pin I/O modes
    app_init();		  // Setup software modules
    usart_init();		// Initialize serial interface   
	spi_init(); 		// Initialize SPI interface as master
	adc_init(); 		// Initialize AD7719 ADC as SPI slave 
	//  usart_write_crlf();
	//  usart_writeln_flash_str(IDN_STR); // Write string to USART interface
	//  usart_write_crlf();

  //  Enable interrupts
  sei();              
 

	// temperature muxer pins init:
	// SA - pins
	DDRA |= 0x3F; // set all SA-pins as outputs
	

	// voltage, current, humidity - muxer pins:
	// SB - pins
	DDRC |= 0x7F; // set all SB - pins as outputs
	
	// SB - muxer test
//	DDRA |= 1<<PA6 ; // set D0-0 lina as output. for tests only !!!
//	PORTA |= 1<<PA6; // set D0-0 line high. for tests only !!!
DDRA &= ~(1<<PA6);

//ADC einschalten
  ADMUX = 0x26;  //0010.0110     // interne Referenzspannung nutzen
  ADCSRA = (1<<ADPS1) | (1<<ADPS0);     // Frequenzvorteiler
  ADCSRA |= (1<<ADEN);                  // ADC aktivieren
  ADCSRA |= (1<<ADSC);



// Main loop
//float temperature;
float resistance;
BOOL heartbeat_enable = TRUE;

U08 SA_mux_val = 0x00;
U08 SB_mux_val = 0x00;

//U08 counter = 0;



while (TRUE)
	 {
	 	// this heartbeat shows how long one single run of this while loop takes
		// measure with a scope.
		if (heartbeat_enable) PORTB ^= (1<<PB3); // toggle Out2_spare --> heartbeat
		//adc_init(); 



_delay_ms(1);
/*


		// if USART data arrives. i.e. data via USB
		// the usart_rx_ready flag is set TRUE
		// now process the incoming data which is stored in 
		// U08 usart_rx_buffer[USART_RX_BUFFER_SIZE]
		// and tell the USART interface, it may receive new data
		// by setting the usart_rx_ready flag FALSE again
		++SA_mux_val;
		if (SA_mux_val == 64) SA_mux_val = 0;
		PORTA = (SA_mux_val & 0x3F); 
				
		usart_write_str((pU08)"SA:");
		usart_write_U08(SA_mux_val,2);
		usart_write_str((pU08)" Sensor:");
		usart_write_U08((SA_mux_val % 8)+1,2);
		usart_write_str((pU08)" an Temperatur_");
		switch (SA_mux_val / 8)
		{
			case 0: usart_write_str((pU08)"C");
			break;
			case 1: usart_write_str((pU08)"D");
			break;
			case 2: usart_write_str((pU08)"A");
			break;
			case 3: usart_write_str((pU08)"B");
			break;
			case 4: usart_write_str((pU08)"G");
			break;
			case 5: usart_write_str((pU08)"H");
			break;
			case 6: usart_write_str((pU08)"E");
			break;
			case 7: usart_write_str((pU08)"F");
			break;
			default: usart_write_str((pU08)"alarm!");
			break;
		}
		usart_write_str((pU08)"\n");
		_delay_us(200);
	


	
for (U08 counter = 0; counter < 10; ++counter) {

		
		while (!ADC_IS_READY())
		{
		// just wait until ADC is redy -- really bad code here!
		}	    			
   		startconv();							//Start a new A/D Conversion
    	//temp = 	readandsendtemp();
		//adcword = getadc();
		resistance = getresistance();
		//temperature = gettemp();
		usart_write_str((pU08)"R:");
		usart_write_float(resistance,3,4);
		usart_write_str((pU08)"kOhm ");	
		

		while (!ADC_IS_READY())
		{
		// just wait until ADC is redy -- really bad code here!
		}	    			
	
		startconv();							//Start a new A/D Conversion
		//temp = 	readandsendtemp();
		//adcword = getadc();
		resistance = getresistance();
		//temperature = gettemp();
		usart_write_str((pU08)"R:");
		usart_write_float(resistance,3,4);
		usart_write_str((pU08)"kOhm\n");	

	_delay_ms(500);
}
usart_write_str((pU08)"\n\n\n");
*/

		++SB_mux_val;
		if (SB_mux_val == 84) SB_mux_val = 0;
		PORTC = (SB_mux_val & 0x7F); 

_delay_ms(5);


usart_write_str((pU08)"8bit-ADC: ");

if (SB_mux_val < 64)
{
		switch (SB_mux_val / 16)
		{
			case 0: usart_write_str((pU08)"voltage_A: ");
			break;
			case 1: usart_write_str((pU08)"voltage_B: ");
			break;
			case 2: usart_write_str((pU08)"voltage_D: ");
			break;
			case 3: usart_write_str((pU08)"voltage_C: ");
			break;
		}

		if (SB_mux_val % 2 == 0) {
			usart_write_str((pU08)"U");
			usart_write_U08( (SB_mux_val%16)/2 , 1 );
		} else {
			usart_write_str((pU08)"I");
			usart_write_U08( ((SB_mux_val%16)-1)/2 , 1 );
		}


} else {


	if (SB_mux_val < 72)  {
		usart_write_str((pU08)"voltage_E: ");
		if (SB_mux_val % 2 == 0) {
			usart_write_str((pU08)"U");
			usart_write_U08( (SB_mux_val%8)/2 , 1 );
		} else {
			usart_write_str((pU08)"I");
			usart_write_U08( ((SB_mux_val%8)-1)/2 , 1 );
		}

	}
else if (SB_mux_val == 72) usart_write_str((pU08)"humidity_A: H0");
else if (SB_mux_val == 73) usart_write_str((pU08)"humidity_A: H1");

else if (SB_mux_val < 82) {
		usart_write_str((pU08)"voltage_F: ");
		if (SB_mux_val % 2 == 0) {
			usart_write_str((pU08)"U");
			usart_write_U08( (SB_mux_val%8)/2 , 1 );
		} else {
			usart_write_str((pU08)"I");
			usart_write_U08( ((SB_mux_val%8)-1)/2 , 1 );
		}

	}
else if (SB_mux_val == 82) usart_write_str((pU08)"humidity_B: H0");
else if (SB_mux_val == 83) usart_write_str((pU08)"humidity_B: H1");
}

for (U08 counter = 0; counter < 10; ++counter) {
	while (ADCSRA & (1<<ADSC) );    // wait until internal ADC is ready
	ADCSRA |= (1<<ADSC);
	float voltage;
	voltage = ( (float)ADCH ) / 256 * 4.096;
	usart_write_str((pU08)" ");
	usart_write_float(voltage,3,4);


	_delay_ms(300);
}
usart_write_str((pU08)"\n");

		
	/*	
		if ( usart_rx_ready == TRUE )
		{
			//understand what it means and react
			
			switch (usart_rx_buffer[0])
			{
				
				case 'h':
				{
					// toggle the heartbeat mode on or off.
					heartbeat_enable = !heartbeat_enable;
					break;
				}
				case 'a':
				{
					// conduct adc - AD7719 SPI interface test
					
					break;
				}
				case 'e':
				{
					// conduct ethernet module SPI interface test
					strtol((char*) usart_rx_buffer+1, NULL, 0);
					break;
				}

				default:
				{
					usart_write_str((pU08)"? you wrote: ");
					usart_write_str((pU08)usart_rx_buffer);
					usart_write_str((pU08)"\n");
					break;
				}
			}
			
			heartbeat_enable = !heartbeat_enable;
			usart_rx_ready = FALSE;
		}
*/
// das ist ein paar schritte zu frh.
// erstmal mssen die interfaces getestet werden.
/*

		for (U08 i = 0; i<16; i++)
	  	{ 
			
	   		if((~PIND) & 0x08)  // PD4 is #ADC_RDY input. Inverted logic! if PD4=0 this evaluates to true					
	    	{		
				PORTA = (PORTA & 0xF0) | ((i) & 0x0F); 	// switch muxer
		   		startconv();							//Start a new A/D Conversion
		    	//temp = 	readandsendtemp();
				//adcword = getadc();
				//resistance = getresistance();
				temperature = gettemp();
				usart_write_float(temperature,2,4);
				usart_write_str((pU08)"\t");

			} // end of if adc ready
			else
			{
			i--;
			}
		} // end of for loop over 16 channels
		usart_write_crlf();

*/

 	}	// end of infinite while loop
} // end of main()



