//-----------------------------------------------------------------------------

#include "ad7719_adc.h"       
#include "spi_master.h"    

//-----------------------------------------------------------------------------

void adc_init(void)
{

  SET_BIT(ADC_DDR,DDD4);		// ADC_RST is uP Output
  CLR_BIT(ADC_PRT,ADC_RST);		// Reset ADC (active low) 	
  SET_BIT(ADC_PRT,ADC_RST);		// Stop Reset ADC


	//Init Configure and Initialize AD7719
	//http://designtools.analog.com/dt/adc/codegen/ad7719.html 

  U8  IOCON1 = 0xC3;	// power switches P1 and P2 switch to PWRGND. I-sources I1 and I2 are switched on.
  U8  IOCON2 = 0x08;	// 0x08 makes no sense... P4 is set HIGH, but is no output.
//  U8  FILTER = 0x45;	//0x45 global use 50Hz = -66dB and 60Hz = -117dB Rejectjon
  U8  FILTER = 0x52;	//0x52 euro use 50Hz = -171dB and 60Hz = -58dB Rejectjon Updaterate = 4Hz

  U8  AD1CON = 0x51;	
	// ARN bit is set->AUS ADC range is: +-REFIN2
	// ACHo and ACH2 are set --> not defined. ???
	// AD1EN is not set. so aux ADC is not enabled anyway.

  U8  AD0CON = 0x8E;
  	// AD0EN is set. main ADC operates according to content of mode register
	// U/#B is set. unipolar encoding. zero is 0x000000. both full scales will be 0xFFFFFF
	// RN2..0 = 1 ,1 ,0 --> multiplication factor 8, maybe ??

  U8  MODE   = 0x02;	// single conversion

	// ADC communiaction works like this:
	// a write operation to the COM register takes place - telling the device what up next.
	// a write or read operation to another register takes place
	// COM register bits have the following meaning:
	//
	// |  7  |  6  |  5  |  4  |  3  |  2  |  1  |  0  |
	// |#WEN |R/#W | zero| zero|  A3 |  A2 |  A1 |  A0 |
	//
	// #WEN (inversed write enable) must be zero inorder to clock more bits into the SPI interface.
	// R/#W (read / not write) must be zero if the next operation will be a WRITE. one if the next is READ.
	// A3-A0 denote the address of the next register.

  const U8 WR_TO_IOCON = 0x07;
  const U8 WR_TO_FILTER = 0x04;
  const U8 WR_TO_AD1CON = 0x03;
  const U8 WR_TO_AD0CON = 0x02;
  const U8 WR_TO_MODE = 0x01;
  const U8 RD_FROM_FILTER = 0x44;

  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(RD_FROM_FILTER);     	// Next Operation is write to IOCON1 and IOCON2  Start SPI
  spi_transfer_byte(0xFF);     	// Next Operation is write to IOCON1 and IOCON2  Start SPI
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high




  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(WR_TO_IOCON);     	// Next Operation is write to IOCON1 and IOCON2  Start SPI
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high

  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(IOCON1);  	// Write to IOCON1 
  spi_transfer_byte(IOCON2);  	// Write to IOCON2 
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high

  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(WR_TO_FILTER);     	// Next Operation is write to FILTER  Start SPI
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high
 
  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(FILTER);  	// Write to FILTER 
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high

  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(WR_TO_AD1CON);     	// Next Operation is write to AD1CON  Start SPI
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high
 
  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(AD1CON);  	// Write to AD1CON
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high

  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(WR_TO_AD0CON);     	// Next Operation is write to AD0CON  Start SPI
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high
 
  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(AD0CON);  	// Write to AD0CON
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high

  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(WR_TO_MODE);     	// Next Operation is write to MODE Start SPI
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high
 
  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(MODE);  	// Write to MODE
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high
} 
          
 void startconv(void)
  {
    U8 COM = 0x01;
	U8 SERIAL = 0x02;
  		  CLR_BIT(PORTD,SPI_AD_CS);       // Set CS low
    	  spi_transfer_byte(COM);        // Next Operation is write to Mode Register
  		  spi_transfer_byte(SERIAL);	 // Start new A/D conversion
		  SET_BIT(PORTD,SPI_AD_CS);  
		  COM = 0x45;
  		  CLR_BIT(PORTD,SPI_AD_CS);       // Set CS low
    	  spi_transfer_byte(COM);        // Next Operation is read from Main ADC Data Register
  		  SET_BIT(PORTD,SPI_AD_CS);        // Set CS high
  }

 U32 read_adc(void)
 { CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
   U32 value=0; 					// actually a 24bit value is returned
   value |= spi_transfer_byte(0) ;
   value =value<<8;
   value |= spi_transfer_byte(0) ;
   value =value<<8;
   value |= spi_transfer_byte(0) ;
   SET_BIT(PORTD,SPI_AD_CS);	// Set CS high
   return value;                                                                                                 
 }   
  
  
