//-----------------------------------------------------------------------------

#include "ad7719_adc.h"       
#include "spi_master.h"    

//-----------------------------------------------------------------------------

void ad7719_init(void)
{

	// ADC communiaction works like this:
	// a write operation to the COM register takes place - telling the device what up next.
	// a write or read operation to another register takes place
	// COM register bits have the following meaning:
	//
	// |  7  |  6  |  5  |  4  |  3  |  2  |  1  |  0  |
	// |#WEN |R/#W | zero| zero|  A3 |  A2 |  A1 |  A0 |
	//
	// #WEN (inversed write enable) must be zero inorder to clock more bits into the SPI interface.
	// R/#W (read / not write) must be zero if the next operation will be a WRITE. one if the next is READ.
	// A3-A0 denote the address of the next register.

  
  CLR_BIT(ADC_PRT,ADC_RST);		// Reset ADC (active low) 	
  SET_BIT(ADC_PRT,ADC_RST);		// Stop Reset ADC


  CLR_BIT(PORTD,SPI_AD_CS);  			// Set CS low
  spi_transfer_byte(FILTER_RD); // Next Operation is write to IOCON
  SET_BIT(PORTD,SPI_AD_CS);

_delay_us(50);

  CLR_BIT(PORTD,SPI_AD_CS);  			// Set CS low
  spi_transfer_byte(0); // Next Operation is write to IOCON
  SET_BIT(PORTD,SPI_AD_CS);

_delay_us(50);

  CLR_BIT(PORTD,SPI_AD_CS);  			// Set CS low
  spi_transfer_byte(IOCON_WR); // Next Operation is write to IOCON
  SET_BIT(PORTD,SPI_AD_CS);
  
  _delay_us(50);

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(IOCON_INIT_HIGH);  	// Write to IOCON1 
  SET_BIT(PORTD,SPI_AD_CS);
_delay_us(50);
  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(IOCON_INIT_LOWBYTE);  	// Write to IOCON2 
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high

_delay_us(50);

  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(FILTER_WR);     	// Next Operation is write to FILTER  Start SPI
  SET_BIT(PORTD,SPI_AD_CS);

_delay_us(50);
  CLR_BIT(PORTD,SPI_AD_CS);

  spi_transfer_byte(FILTER_INIT);  	// Write to FILTER 
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high
_delay_us(50);
  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(AD1CON_WR);     	// Next Operation is write to AD1CON  Start SPI
  SET_BIT(PORTD,SPI_AD_CS);

_delay_us(50);

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(AD1CON_INIT);  	// Write to AD1CON
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high

_delay_us(50);

  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(AD0CON_WR);     	// Next Operation is write to AD0CON  Start SPI
  SET_BIT(PORTD,SPI_AD_CS);

_delay_us(50);

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(AD0CON_INIT);  	// Write to AD0CON
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high

_delay_us(50);

  CLR_BIT(PORTD,SPI_AD_CS);  	// Set CS low
  spi_transfer_byte(MODE_WR);     	// Next Operation is write to MODE Start SPI
  SET_BIT(PORTD,SPI_AD_CS);

_delay_us(50);

  CLR_BIT(PORTD,SPI_AD_CS);
  spi_transfer_byte(MODE_CONT);  	// Write to MODE
  SET_BIT(PORTD,SPI_AD_CS);	// Set CS high

_delay_us(50);

  CLR_BIT(PORTD,SPI_AD_CS);  			// Set CS low
  spi_transfer_byte(FILTER_RD); // Next Operation is write to IOCON
  SET_BIT(PORTD,SPI_AD_CS);

_delay_us(50);

  CLR_BIT(PORTD,SPI_AD_CS);  			// Set CS low
  spi_transfer_byte(0); // Next Operation is write to IOCON
  SET_BIT(PORTD,SPI_AD_CS);

_delay_us(50);


} 
          
void startconv(U08 continuous)
{
	CLR_BIT(PORTD,SPI_AD_CS);       // Set CS low
	spi_transfer_byte(MODE_WR);        // Next Operation is write to Mode Register
  SET_BIT(PORTD,SPI_AD_CS);
  CLR_BIT(PORTD,SPI_AD_CS);
	if (continuous)	spi_transfer_byte(MODE_SINGLE);	 // Start new A/D conversion
	else spi_transfer_byte(MODE_CONT);	 // Start continous conversion mode
	SET_BIT(PORTD,SPI_AD_CS);  
}

void stopconv(void)
{
	CLR_BIT(PORTD,SPI_AD_CS);       // Set CS low
	spi_transfer_byte(MODE_WR);        // Next Operation is write to Mode Register
    SET_BIT(PORTD,SPI_AD_CS);
    CLR_BIT(PORTD,SPI_AD_CS);
	spi_transfer_byte(MODE_IDLE);
	SET_BIT(PORTD,SPI_AD_CS);  
}


U32 read_adc(void)
{ 
	CLR_BIT(PORTD,SPI_AD_CS);       // Set CS low
	spi_transfer_byte(AD0DAT_RD);   // Next Operation is read from Main ADC Data Register
    SET_BIT(PORTD,SPI_AD_CS);
	_delay_us(50);

    CLR_BIT(PORTD,SPI_AD_CS);
	U32 value=0; 					// actually a 24bit value is returned
	value |= spi_transfer_byte(0) ;
	value =value<<8;
	value |= spi_transfer_byte(0) ;
	value =value<<8;
	value |= spi_transfer_byte(0) ;
	SET_BIT(PORTD,SPI_AD_CS);	// Set CS high
	return value;                                                                                                 
}   
  
  
