#ifndef __AD7719_ADC_H
#define __AD7719_ADC_H
//-----------------------------------------------------------------------------

#include "typedefs.h"
#include "application.h"
#include "num_conversion.h"
//-----------------------------------------------------------------------------
// Bit Definitions
#define ADC_RDY PD6
#define ADC_RST PD7
#define AD7719_IS_READY() (!(PIND & (1<<PD6))) // TRUE if PD6=0 AD_RDY is inverted logic.

// Port Definitions
#define ADC_PRT PORTD
#define ADC_DDR DDRD
#define ADC_PIN PIND


// ON CHIP REGISTER ADDRESSES
#define STATUS_RD 0x40

#define MODE_WR 0x01
#define MODE_RD 0x41

#define AD0CON_WR 0x02
#define AD0CON_RD 0x42

#define AD1CON_WR 0x03
#define AD1CON_RD 0x43

#define FILTER_WR 0x04
#define FILTER_RD 0x44

#define AD0DAT_RD 0x45
#define AD1DAT_RD 0x46

#define IOCON_WR 0x07
#define IOCON_RD 0x47

#define AD0OFS_WR 0x08
#define AD0OFS_RD 0x48

#define AD1OFS_WR 0x09
#define AD1OFS_RD 0x49

#define AD0GAIN_WR 0x0A
#define AD0GAIN_RD 0x4A

#define AD1GAIN_WR 0x0B
#define AD1GAIN_RD 0x4B

#define ID_RD 0x4F

// REGISTER INIT VALUES

	//Init Configure and Initialize AD7719
	//http://designtools.analog.com/dt/adc/codegen/ad7719.html 

#define IOCON_INIT_HIGH 0x03	//0000.0011 // I-sources I1 and I2 are switched on, thats all
#define IOCON_INIT_LOWBYTE 0x00

#define FILTER_INIT 0x52	//0x52 euro use 50Hz = -171dB and 60Hz = -58dB Rejectjon Updaterate = 4Hz
											// 0x52=82 decimal. f_ADC=16.6Hz; t_ADC=60ms; t_settle = 120ms

#define AD1CON_INIT 0x31	//0011.0001  	
	// AD1EN is set --> AUX ADc is used for Temp measurement.
	// ACH = 011 --> Tempsensor
	// U/#B = 0 --> bipolar, but i'm not entirely sure if this is correct.
	// ARN = 1 --> input range is REFIN2 , but when tempsensor is chosen, internal ref is used ... 

#define AD0CON_INIT 0x8E // 1000.1110
	// AD0EN is set
	// WL is cleared --> 24bit
	// CH = 00 --> AIN1 , AIN2 used 
	// U/#B = 1 --> unipolar
	// RN=110 --> input range = +-1.28V --> whatever this means in ratiometric measurements.


#define MODE_IDLE 0x01
#define MODE_SINGLE 0x02
#define MODE_CONT 0x03
#define MODE_INTERNAL_ZERO_CAL 0x04		// not tested
#define MODE_INTERNAL_FULL_CAL 0x05		// not tested

// since the ADC is chopped, one should wait 3 conversions
// after the muxer was switched, until the reading is okay.
#define READINGS_UNTIL_AD7719_SETTLED 3

void ad7719_init(void);
void startconv(U08 continuous);
void stopconv(void);
U32 read_adc(void);
//-----------------------------------------------------------------------------
#endif
