//-----------------------------------------------------------------------------

#include "application.h"
 #include <avr/wdt.h> 


//-----------------------------------------------------------------------------

volatile U08 app_reset_source;
//-----------------------------------------------------------------------------

void app_init(void)
{
  app_reset_source = MCUSR; // Save last reset source
  MCUSR = 0x00; // Clear reset source for next reset cycle


	// Dangerous here: I still do not know much about the watchdog.
	// This code is still from Udo Juerss. 

  // The watchdog timer is disabled by default ("startup.asm")
	#ifdef USE_WATCHDOG
	 WDTCSR = WDTOE | (1 << WDE); // Enable watchdog reset (~16ms)
	#endif

	// define PORTS
	// USART
	DDRD &= ~(1<<PD0);				// PD0 = RXD is input
	DDRD |= 1<<PD1; 					// PD1 = TXD is output
	

	// SPARE OUT/-INPUTS
	DDRB |= (1<<PB2) | (1<<PB3); 	// set Out1_spare & out2_spare as outputs
	DDRA &= ~(1<<PA7);				// set In1_spare as input
	DDRC &= ~(1<<PC7);				// set In2_spare as input
	PORTA |= (1<<PA7); 				// swtich on pullup on In1_spare
	PORTC |= (1<<PC7); 				// swtich on pullup on In2_spare

	// ATmega internal ADC input 
	DDRA &= ~(1<<PA6);

	// MUXER ADDRESS OUTs
	DDRA |= 0x3F; // SA-pins -> output
	DDRC |= 0x7F; // SB-pins -> output

	// SPI
	// set all CS's: output
	DDRB |= (1 << SPI_E_CS);
	DDRD |= (1 << SPI_AD_CS) |(1 << SPI_M_CS) |(1 << SPI_A_CS);

	// set all Chips selects HIGH
	PORTB |= (1 << SPI_E_CS);
	PORTD |= (1 << SPI_AD_CS) |(1 << SPI_M_CS) |(1 << SPI_A_CS);

	// set MOSI and SCK: output & // set MISO: input
	SPI_DDR |= (1 << SPI_MOSI);
	SPI_DDR |= (1 << SPI_SCLK);
	SPI_DDR &= ~(1 << SPI_MISO);

	// set MOSI, SCK: HIGH. MISO leave alone.
	SPI_PRT |= (1 << SPI_MOSI);
	SPI_PRT |= (1 << SPI_SCLK);
	SPI_PRT |= (1 << SPI_MISO);

	// ADC 
	DDRD &= ~(1<<PD6);					// PD6 is AD_READY input
	DDRD |= 1<<PD7;							// PD7 is AD_RESET output

	// ACCELEROMETER
	DDRD &= ~(1<<PD2);					// PD2 is ACC_READY input

	//MAX6662   <--- not assembled anymore
	// DDRB &= ~(1<<PB0); 			// PB0 is over temperature alert input
	// DDRB &= ~(1<<PB1);				// PB1 is general temperature altert input


}



//-----------------------------------------------------------------------------

void app_set_watchdog_prescaler(tWDT_PRESCALE wdt_prescale) // Set watchdog prescale
{
  U08 sreg_backup = SREG; // Copy status register to variable
  U08 wdtcsr_value = WDE + wdt_prescale; // Set new prescale value to variable

  cli(); // Disable interrups
  wdt_reset(); // Reset watchdog

  WDTCR |= (1 << WDTOE) | (1 << WDE); // Unlock register access, 4 cycles to store new value
  WDTCR = wdtcsr_value; // Set new watchdog prescaler
  SREG = sreg_backup; // Restore status register
}
