#ifndef __APPLICATION_H
#define __APPLICATION_H
//-----------------------------------------------------------------------------

#include "typedefs.h"
//-----------------------------------------------------------------------------

#define USART_RX_BUFFER_SIZE 32 // Receive buffer size
#define USART_TX_BUFFER_SIZE 255 // Receive buffer size. MUST not be larger 255

#define USART_BAUDRATE 9600 // USART baudrate original
#define USART_USE_TX // Transmitter used?
#define USART_USE_RX // Receiver used?
//#define USART_USE_RX_IRQ // RX interrupt used?
#define USART_USE_UPPERCASE // Convert received chars to uppercase?
//-----------------------------------------------------------------------------

// SPI DEFINITIONS
// Port Definitions
#define SPI_PRT PORTB
#define SPI_DDR DDRB

// Bit Definitions
#define SPI_SCLK PB7
#define SPI_MOSI PB5
#define SPI_MISO PB6

#define SPI_E_CS PB4 		
#define SPI_AD_CS PD3 		
#define SPI_M_CS PD4		
#define SPI_A_CS PD5		




//-----------------------------------------------------------------------------
extern volatile U08 app_reset_source;
//-----------------------------------------------------------------------------

void app_init(void); // Initialize application
void app_set_watchdog_prescaler(tWDT_PRESCALE wdt_prescale); // Set watchdog prescale
//-----------------------------------------------------------------------------

#endif
