#ifndef __USART_H
#define __USART_H
//-----------------------------------------------------------------------------

#include "typedefs.h"
#include "application.h"
#include "num_conversion.h"
//-----------------------------------------------------------------------------

#define USART_CHAR_BS 8
#define USART_CHAR_LF 10
#define USART_CHAR_CR 13
#define USART_CHAR_ESC 27
#define USART_CHAR_SPC 32
//-----------------------------------------------------------------------------

#define USART_SET_BAUDRATE(br) (UBRRH = (U08)((((U32)F_CPU) /\
                                ((U32)br * 16) - 1) >> 8),\
                                UBRRL = (U08)(((U32)F_CPU) /\
                                ((U32)br * 16) - 1))
//-----------------------------------------------------------------------------
/*
extern U08 usart_rx_buffer[];
extern volatile BOOL usart_rx_ready;
extern volatile BOOL ISR_toggle_out;
extern U08 usart_received_chars;
*/
extern bool usart_tx_buffer_overflow;
extern U08 usart_tx_buffer_index;
extern U08 usart_tx_buffer[USART_TX_BUFFER_SIZE];
//-----------------------------------------------------------------------------

void usart_init(void);
void usart_write_char(U08 data);
void usart_write_crlf(void);
void usart_write_str(pU08 str);
void usart_writeln_str(pU08 str);
void usart_write_flash_str(fpU08 str);
void usart_writeln_flash_str(fpU08 str);
void usart_write_U08(U08 value,U08 digits);
void usart_write_S08(S08 value,U08 digits);
void usart_write_U08_hex(U08 value);
void usart_write_U08_bin(U08 value);
void usart_write_U16(U16 value,U08 digits);
void usart_write_S16(S16 value,U08 digits);
void usart_write_U16_hex(U16 value);
void usart_write_U32(U32 value,U08 digits);
void usart_write_S32(S32 value,U08 digits);
void usart_write_U32_hex(U32 value);
void usart_write_float(float value,U08 decimals,U08 digits);
//-----------------------------------------------------------------------------

#endif
