#ifndef FAD_H_SEEN
#define FAD_H_SEEN

#define SERVER_NAME "FADctrl"       // Name to use in DIM
#include "Evidence.h"

#include <readline/readline.h>

#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <time.h>
#include <math.h>
#include <errno.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/time.h>
#include <limits>

#include "FADBoard.h"

const int DEFAULT_NUM_CALIB_EVENTS = 100;
const char CALIB_DIRECTORY[] = "~/";

enum ModeType {idle, acalib, tcalib};

class FAD: public EvidenceServer {

	pthread_t MainThread;
	DimCommand *Command;
	DimService *ConsoleOut;
	char *ConsoleText;
	std::vector<std::string> Parameter;
	ModeType Mode;
	volatile bool Cancel;
    void PrintUsage();
	void commandHandler();
	bool Match(std::string, const char *);
	void AmplitudeCalibration();
	static void LaunchAmplitudeCalibration(class FAD *);
	void EventThread();
	static void LaunchEventThread(class FAD *);
	pthread_t Thread;
	float EventUpdateDelay;

	int NumCalibEvents;
	
	std::vector<std::string> BoardList;
	std::vector<class FADBoard *> Boards;

	struct Range {
	  int Min;
	  int Max;
	};

	bool ConvertToDouble(std::string, double *);
	bool ConvertToInt(std::string, int *);
	bool ConvertToRange(std::string, struct Range &);

  public:
    FAD();
    ~FAD();

	void cmd_exit();		void cmd_help();
	void cmd_board();		void cmd_status();
	void cmd_acalib();		void cmd_serial();
	void cmd_trigger(); 	void cmd_socketmode();
	void cmd_srclk();		void cmd_sclk();
	void cmd_dwrite();		void cmd_domino();
	void cmd_wmode();		void cmd_rmode();
	void cmd_dmode();		void cmd_dac();
	void cmd_roi();			void cmd_address();
	void cmd_phase();		void cmd_send();
	void cmd_cancel();		void cmd_update();

    void EnableDomino();
    void DisableDomino();
    void SoftTrigger();
    void SetDOMINOMode(int);
    void SetDOMINOReadMode(int);
    void SetDOMINOWaveMode(int);
    bool ReadCalibration();
    void PrintMessage(const char*, ...);
	
	int Pipe[2];
};

#endif
