#ifndef FADBoard_H_SEEN
#define FADBoard_H_SEEN

#include <ctype.h>
#include <time.h>
#include <math.h>
#include <errno.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/time.h>

#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <sys/socket.h>
#include <netdb.h>

#include "FAD.h"
#include "FADFormat.h"

const unsigned int READ_BUFFER_SIZE = 1000000;

class FADBoard {

	class FAD *m;
	int Socket;
	pthread_t Thread;
	pthread_mutex_t Mutex;
	DimService *DIM_Name;
	DimService *DIM_ID;
	DimService *DIM_Temp;
	DimService *DIM_ROI;
	DimService *DIM_DAC;

	void ReadLoop();
	static void LaunchThread(class FADBoard *);

  public: 
    FADBoard(std::string, unsigned short, class FAD *, unsigned int);
    ~FADBoard();

	struct BoardStatus {
	  unsigned short BoardID;
	  unsigned short FirmwareRevision;
	  unsigned long TriggerID;
	  unsigned char TriggerType;
	  unsigned short TriggerCell[NChips];
	  unsigned short ROI[NChips][NChannels];
	  unsigned short DAC[NDAC];
	  float Temp[NTemp];
	  struct timeval Update;
	} Status;

	short Data[NChips][NChannels][NBins];
	short Baseline[NChips][NChannels][NBins];
	double Gain[NChips][NChannels][NBins];
	double SecondaryBaseline[NChips][NChannels][NBins];
	float ACalibTemp;
	time_t ACalibTime;

	long int Sum[NChips][NChannels][NBins];
	unsigned int NumForSum;
	bool DoSum;
	bool SumPhysPipeline;

	void Send(const void *, size_t);
	void Send(unsigned short);
	struct BoardStatus GetStatus();
	void AccumulateSum(unsigned int, bool);
	void Lock();
	void Unlock();

	char *Name;
	bool InitOK;
	bool CommError;
	bool Active;
	bool Continue;
	pthread_cond_t CondVar;
};

#endif
