//
//  FADctrl
//

#include <stdio.h>
#include <readline/history.h>
#include <string>

#include "FAD.h"

using namespace std;

const string READLINE_HIST_FILE = string(getenv("HOME"))+"/.history_FADctrl";

// ================
//   Main program
// ================

int main() {

  // Uses getc() for readline library (allows interruption by signal) and load history buffer
  rl_getc_function = getc;
  read_history(READLINE_HIST_FILE.c_str());

  system("clear");
  printf("\n*** FADctrl (built %s, %s, revision %s) *** \n\n",__DATE__, __TIME__, REVISION);

  // Construct main instance (static ensures destructor is called with exit())
  static class FAD M;

  // Do not kill process if writing to closed socket
  signal(SIGPIPE, SIG_IGN);

  // Initialise all boards
  DimClient::sendCommand(SERVER_NAME"/Command", "dwrite off");
  DimClient::sendCommand(SERVER_NAME"/Command", "domino off");
  DimClient::sendCommand(SERVER_NAME"/Command", "dac 0 25000");
  DimClient::sendCommand(SERVER_NAME"/Command", "dac 1-3 0");
  DimClient::sendCommand(SERVER_NAME"/Command", "dac 4-7 28800");
  DimClient::sendCommand(SERVER_NAME"/Command", "domino on");
  DimClient::sendCommand(SERVER_NAME"/Command", "dwrite on");
  DimClient::sendCommand(SERVER_NAME"/Command", "roi all 1024");
  DimClient::sendCommand(SERVER_NAME"/Command", "trigger enable");
  M.PrintMessage("Finished initalizing all boards\n");

  // Command loop
  char *Command;
  std::string LastHist;

  while (!M.ExitRequest) {
    Command = readline("\rFADctrl>");

	// Check for interruption by signal
    if (Command == NULL) continue;

	// Add command to history
    if(strlen(Command) > 0 && LastHist != Command) {
	  add_history(Command);
	  LastHist = Command;
	}

    // Process command
	DimClient::sendCommand(SERVER_NAME"/Command", Command);
    free(Command);
  }
  
  // Save history buffer  
  int Ret = write_history(READLINE_HIST_FILE.c_str());
  if (Ret != 0 ) printf("Error writing history file to '%s' (%s)\n", READLINE_HIST_FILE.c_str(), strerror(Ret));
}
