#ifndef MARS_MHillas
#define MARS_MHillas

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TEllipse;

class MGeomCam;
class MCerPhotEvt;

class MHillas : public MParContainer
{
private:
    Float_t fAlpha;     // [deg] Angle between the length axis of the ellipse and the camera center
    Float_t fTheta;     // [rad] Angle between the x axis and the center of the ellipse
    Float_t fWidth;     // Width of the ellipse
    Float_t fLength;    // Length of the ellipse
    Float_t fSize;      // Size of the ellipse
    Float_t fDist;      // Distance of the ellipse COM from the camera center

    TEllipse *fEllipse; //! Graphical Object to Display Ellipse

public:
    MHillas(const char *name=NULL, const char *title=NULL);
    ~MHillas();

    void Reset();

    Bool_t Calc(const MGeomCam &geom, const MCerPhotEvt &pix);

    void Print(Option_t *opt=NULL) const;
    void Draw(Option_t *opt=NULL);
    void Paint(Option_t *opt=NULL);

    void Clear(Option_t *opt=NULL);

    Float_t GetAlpha() const  { return fAlpha; }
    Float_t GetWidth() const  { return fWidth; }
    Float_t GetLength() const { return fLength; }
    Float_t GetDist() const   { return fDist; }
    Float_t GetSize() const   { return fSize; }
    Float_t GetTheta() const  { return fTheta; }

    void AsciiRead(ifstream &fin);
    void AsciiWrite(ofstream &fout) const;

    ClassDef(MHillas, 1) // Storage Container for Hillas Parameter
};

#endif

