#ifndef MARS_MMcPedestalCopy
#define MARS_MMcPedestalCopy

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MMcPedestalCopy                                                         //
//                                                                         //
// This task copies the pedestals from the MC data into the corresponding  //
// MARS Container (MPedestals). This seems to be overdone, but at this     //
// point you have a standard interface to access the pedestals             //
// (MPedestals), which makes it possible that from now on all pedestals    //
// can be treated in the same way                                          //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MMcFadcHeader;
class MPedestalCam;

class MMcPedestalCopy : public MTask
{
    const MMcFadcHeader *fMcPedestals;  //
          MPedestalCam  *fPedestals;    //

          TString       *fSrc;

public:
    MMcPedestalCopy(const UInt_t num = 0,
                    const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MMcPedestalCopy, 0)   // Task which copies the pedestals from the MC into the standard container
};

#endif
