#ifndef EVIDENCE_H_SEEN
#define EVIDENCE_H_SEEN

#include <stdio.h>
#include <stdarg.h>
#include <string>
#include <sstream>
#include <iomanip>
#include <errno.h>
#include <vector>
#include <map>
#include <set>

#include <exception>
#include <cxxabi.h>

#include "dis.hxx"
#include "dic.hxx"

#define NO_LINK (char *) "__&DIM&NOLINK&__" // Data if no link available
#define EVIDENCE_REVISION "$Revision: 10143 $"

void ConfigChanged();

// Class declation of Evidence server
class EvidenceServer: public DimServer {

	// Internal class for configuration requests
	class Config: public DimInfo, public DimCommand, public DimRpcInfo {

		DimInfo *Service;

		void rpcInfoHandler();
		void commandHandler();
		void infoHandler();

	  public:
		Config();
		~Config();

		int ConfigTimeStamp;
		std::string CurrentItem;
	};

	struct Item {
	  std::string Value;
	  int Time;
	};
	std::map<std::string, struct Item> List;

	struct Message {
      int Severity;
	  char Text[];
	};

	std::string Name;
    DimService *MessageService;
	struct Message *MessageData;
	class Config *ConfClass;
	static pthread_mutex_t Mutex;
	static std::set<pthread_t> Threads;
	static EvidenceServer *This;

    static void SignalHandler(int); // static for signal()
    static void Terminate();  		// static for set_terminate()
	virtual void errorHandler(int, int, char *);
	virtual void exitHandler(int);
    static void CallConfigChanged();	// static for phread_create()

  public:
    EvidenceServer(std::string);
	~EvidenceServer();

	enum {INFO=0, WARN=10, ERROR=20, FATAL=30};

	void Message(int, const char *, ...);
	static void SendToLog(const char *, ...);
	std::string GetConfig(std::string, std::string = std::string());
	virtual void ConfigChanged() {};
	static void Lock();
	static void Unlock();
	static std::string ToString(char *, void *, int);
	static bool ServiceOK(DimInfo *);
	static bool ServiceOK(DimRpcInfo *);
	static bool ServiceOK(DimCurrentInfo *);
	static std::vector<std::string> Tokenize(const std::string &, const std::string & = " ");

    bool ExitRequest;
};

// Class declaration of EvidenceHistory
class EvidenceHistory {

  public:  
  	struct Item {
	  int Time;
	  int Size;
	  char Data[]; // Size bytes follow
	} __attribute__((packed));

	static const struct Item WrapMark;
	static const struct Item EndMark;

  private:
	std::string Name;
	char *Buffer;
	int BufferSize;
	char *DataStart;
	struct Item *Pointer;
	
  public:
	EvidenceHistory(std::string);
	~EvidenceHistory();	

	bool GetHistory();
	char *GetFormat();
	const struct Item *Next();
	void Rewind();
};
#endif
