#ifndef MARS_MReadTree
#define MARS_MReadTree

#ifndef MARS_MTask
#include "MTask.h"
#endif

class TChain;

class MReadTree : public MTask
{
private:
    TChain *fChain;            // Pointer to tree

    UInt_t  fNumEntry;         // Number of actual entry
    UInt_t  fNumEntries;       // Number of Events in Tree

    Bool_t  fBranchChoosing;   // Flag for branch choosing method
    Bool_t  fAutoEnable;       // Flag for auto enabeling scheme

    TOrdCollection *fVetoList; // List of Branches which are not allowed to get enabled

    void EnableBranches(MParList *plist);
    void EnableBranchChoosing();

public:
    MReadTree(const char *treename, const char *filename=NULL, const char *name=NULL, const char *title=NULL);
    ~MReadTree();

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    Int_t  AddFile(const char *fname);
    void   VetoBranch(const char *name);

    void   EnableBranch(const char *name);

    Bool_t GetEvent();

    Bool_t DecEventNum(UInt_t dec=1); // decrease number of event (position in tree)
    Bool_t IncEventNum(UInt_t inc=1); // increase number of event (position in tree)
    Bool_t SetEventNum(UInt_t nr);    // set number of event (position in tree)

    UInt_t GetEventNum() const { return fNumEntry;   }
    UInt_t GetEntries() const  { return fNumEntries; }

    void   DisableAutoScheme() { fAutoEnable = kFALSE; }

    ClassDef(MReadTree, 0)	// Reads one tree
};

#endif
