----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       Q. Weitzel
-- 
-- Create Date:    February 2011 
-- Design Name:    
-- Module Name:    ftm_definitions 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    library file for FTM design
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- use IEEE.NUMERIC_STD.ALL;

package ftm_array_types is

  -- data arrays for a single FTU
  type FTU_enable_array_type is array (0 to 3) of std_logic_vector(15 downto 0);
  type FTU_dac_array_type    is array (0 to 4) of std_logic_vector(15 downto 0);
  type FTU_rate_array_type   is array (0 to 4) of std_logic_vector(31 downto 0);
  type active_FTU_array_type is array (0 to 3) of std_logic_vector(15 downto 0);
  
end ftm_array_types;


library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
-- use IEEE.NUMERIC_STD.ALL;

package ftm_constants is

  constant NO_OF_CRATES         : integer :=  4;
  constant NO_OF_FTUS_PER_CRATE : integer := 10;
  constant NO_OF_FTU_ENABLE_REG : integer :=  4;
  constant NO_OF_FTU_DAC_REG    : integer :=  5;
  
  --internal FPGA clock frequencies
  constant INT_CLK_FREQUENCY_1 : integer :=  50000000;  --  50MHz
  constant INT_CLK_FREQUENCY_2 : integer := 250000000;  -- 250MHz

  --FTM address and firmware ID
  constant FTM_ADDRESS : std_logic_vector(7 downto 0) := "11000000";  -- 192
  constant FIRMWARE_ID : std_logic_vector(7 downto 0) := "00000001";  -- firmware version
  
  --communication with FTUs
  constant FTU_RS485_BAUD_RATE   : integer := 250000;  -- bits / sec in our case
  constant FTU_RS485_TIMEOUT     : integer := (INT_CLK_FREQUENCY_1 * 5) / 1000;  -- 5ms @ 50MHz (250000 clk periods)
  constant FTU_RS485_BLOCK_WIDTH : integer := 224;     -- 28 byte protocol
  constant FTU_RS485_START_DELIM : std_logic_vector(7 downto 0) := "01000000";  -- start delimiter "@"
  
  --CRC setup
  constant CRC_POLYNOMIAL : std_logic_vector(7 downto 0) := "00000111";  -- 8-CCITT
  constant CRC_INIT_VALUE : std_logic_vector(7 downto 0) := "11111111";
  
  --DNA identifier for simulation
  constant DNA_FOR_SIM : bit_vector := X"01710000E0000501";

  --RAM address offsets and widths
  constant STATIC_RAM_ACT_FTU_OFFSET : integer := 16#1B0#;
  constant STATIC_RAM_CFG_FTU_OFFSET : integer := 16#020#;
  constant STATIC_RAM_ADDR_WIDTH     : integer := 12;
  
end ftm_constants;
