-- VHDL Entity FACT_FAD_lib.control_unit.symbol
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 13:10:37 12.02.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
LIBRARY FACT_FAD_LIB;
USE FACT_FAD_LIB.fad_definitions.ALL;

ENTITY control_unit IS
   PORT( 
      clk               : IN     STD_LOGIC;
      config_addr       : IN     std_logic_vector (7 DOWNTO 0);
      config_rd_en      : IN     std_logic;
      config_start      : IN     std_logic;
      config_wr_en      : IN     std_logic;
      config_busy       : OUT    std_logic;
      config_data_valid : OUT    std_logic;
      config_ready      : OUT    std_logic;
      -- --
      config_rw_ack     : OUT    std_logic  := '0';
      -- --
      config_rw_ready   : OUT    std_logic  := '0';
      config_started    : OUT    std_logic  := '0';
      dac_array         : OUT    dac_array_type;
      roi_array         : OUT    roi_array_type;
      config_data       : INOUT  std_logic_vector (15 DOWNTO 0)
   );

-- Declarations

END control_unit ;

--
-- VHDL Architecture FACT_FAD_lib.control_unit.struct
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 13:10:37 12.02.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;
LIBRARY FACT_FAD_LIB;
USE FACT_FAD_LIB.fad_definitions.ALL;

LIBRARY FACT_FAD_lib;

ARCHITECTURE struct OF control_unit IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL ram_addr     : std_logic_VECTOR(7 DOWNTO 0);
   SIGNAL ram_data_in  : std_logic_VECTOR(15 DOWNTO 0);
   SIGNAL ram_data_out : std_logic_VECTOR(15 DOWNTO 0);
   SIGNAL ram_wren     : std_logic_VECTOR(0 DOWNTO 0);


   -- Component Declarations
   COMPONENT controlRAM_16bit_x256
   PORT (
      clka  : IN     std_logic ;
      dina  : IN     std_logic_VECTOR (15 DOWNTO 0);
      addra : IN     std_logic_VECTOR (7 DOWNTO 0);
      wea   : IN     std_logic_VECTOR (0 DOWNTO 0);
      douta : OUT    std_logic_VECTOR (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT control_manager
   GENERIC (
      NO_OF_ROI  : integer := 36;
      NO_OF_DAC  : integer := 8;
      ADDR_WIDTH : integer := 8
   );
   PORT (
      clk               : IN     std_logic ;
      ram_data_out      : IN     std_logic_vector (15 DOWNTO 0);
      config_ready      : OUT    std_logic                      := '0';
      config_started    : OUT    std_logic                      := '0';
      config_start      : IN     std_logic ;
      config_data       : INOUT  std_logic_vector (15 DOWNTO 0) := (others => 'Z');
      config_addr       : IN     std_logic_vector (ADDR_WIDTH - 1 DOWNTO 0);
      config_wr_en      : IN     std_logic ;
      config_rd_en      : IN     std_logic ;
      config_data_valid : OUT    std_logic                      := '0';
      config_busy       : OUT    std_logic                      := '0';
      -- --
      config_rw_ack     : OUT    std_logic                      := '0';
      -- --
      config_rw_ready   : OUT    std_logic                      := '0';
      -- --
      ram_addr          : OUT    std_logic_vector (ADDR_WIDTH - 1 DOWNTO 0);
      ram_data_in       : OUT    std_logic_vector (15 DOWNTO 0);
      ram_write_en      : OUT    std_logic_vector (0 DOWNTO 0);
      dac_array         : OUT    dac_array_type ;
      roi_array         : OUT    roi_array_type 
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : controlRAM_16bit_x256 USE ENTITY FACT_FAD_lib.controlRAM_16bit_x256;
   FOR ALL : control_manager USE ENTITY FACT_FAD_lib.control_manager;
   -- pragma synthesis_on


BEGIN

   -- Instance port mappings.
   I_control_ram : controlRAM_16bit_x256
      PORT MAP (
         clka  => clk,
         dina  => ram_data_in,
         addra => ram_addr,
         wea   => ram_wren,
         douta => ram_data_out
      );
   I_control_manager : control_manager
      GENERIC MAP (
         NO_OF_ROI  => 36,
         NO_OF_DAC  => 8,
         ADDR_WIDTH => 8
      )
      PORT MAP (
         clk               => clk,
         ram_data_out      => ram_data_out,
         config_ready      => config_ready,
         config_started    => config_started,
         config_start      => config_start,
         config_data       => config_data,
         config_addr       => config_addr,
         config_wr_en      => config_wr_en,
         config_rd_en      => config_rd_en,
         config_data_valid => config_data_valid,
         config_busy       => config_busy,
         config_rw_ack     => config_rw_ack,
         config_rw_ready   => config_rw_ready,
         ram_addr          => ram_addr,
         ram_data_in       => ram_data_in,
         ram_write_en      => ram_wren,
         dac_array         => dac_array,
         roi_array         => roi_array
      );

END struct;
