#ifndef FADBoard_H_SEEN
#define FADBoard_H_SEEN

#include <ctype.h>
#include <time.h>
#include <math.h>
#include <errno.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/time.h>

#include <stdlib.h>
#include <string.h>
#include <iostream>
#include <algorithm>
#include <sys/socket.h>
#include <netdb.h>

#include "FAD.h"
#include "FADFormat.h"

const unsigned int READ_BUFFER_SIZE = 1000000;

class FADBoard: public DimThread {

	class FAD *m;
	int Socket;
	pthread_mutex_t Mutex;
	DimService *DIM_Name, *DIM_ID, *DIM_Temp, *DIM_ROI, *DIM_DAC;

	void ReadLoop();
	static void LaunchThread(class FADBoard *);
	void threadHandler();

  public: 
    FADBoard(std::string, unsigned short, class FAD *, unsigned int);
    ~FADBoard();

	struct BoardStatus {
	  unsigned short BoardID;
	  unsigned short FirmwareRevision;
	  unsigned long TriggerID;
	  unsigned char TriggerType;
	  unsigned short TriggerCell[NChips];
	  unsigned short ROI[NChips][NChannels];
	  unsigned short DAC[NDAC];
	  float Temp[NTemp];
	  struct timeval Update;
	} Status;

	short Data[NChips][NChannels][NBins];
	long int Sum[NChips][NChannels][NBins];
	short Baseline[NChips][NChannels][NBins];
	double Gain[NChips][NChannels][NBins];
	double SecondaryBaseline[NChips][NChannels][NBins];
	float ACalibTemp;
	time_t ACalibTime;


	void Send(const void *, size_t);
	void Send(unsigned short);
	struct BoardStatus GetStatus();
	void AmplitudeCalibration();
	void Lock();
	void Unlock();

	unsigned short Port;
	char *Name;
	bool CommOK;
	bool Active;
	bool Continue;
	pthread_t Thread;
	pthread_cond_t CondVar;
};

#endif
