-- VHDL Entity FACT_FAD_lib.FAD_Board.symbol
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 17:38:00 16.02.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY FAD_Board IS
   PORT( 
      A0_D       : IN     std_logic_vector (11 DOWNTO 0);
      A1_D       : IN     std_logic_vector (11 DOWNTO 0);
      A2_D       : IN     std_logic_vector (11 DOWNTO 0);
      A3_D       : IN     std_logic_vector (11 DOWNTO 0);
      A_OTR      : IN     std_logic_vector (3 DOWNTO 0);
      D0_SROUT   : IN     std_logic;
      D1_SROUT   : IN     std_logic;
      D2_SROUT   : IN     std_logic;
      D3_SROUT   : IN     std_logic;
      D_PLLLCK   : IN     std_logic_vector (3 DOWNTO 0);
      D_T_in     : IN     std_logic_vector (1 DOWNTO 0);
      LINE       : IN     std_logic_vector ( 5 DOWNTO 0 );
      REFCLK     : IN     std_logic;
      RS485_C_DI : IN     std_logic;
      RS485_E_DI : IN     std_logic;
      TRG        : IN     STD_LOGIC;
      W_INT      : IN     std_logic;
      X_50M      : IN     STD_LOGIC;
      A0_T       : OUT    std_logic_vector (7 DOWNTO 0) := (others => '0');
      A1_T       : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      AMBER_LED  : OUT    std_logic;
      A_CLK      : OUT    std_logic_vector (3 DOWNTO 0);
      DAC_CS     : OUT    std_logic;
      DENABLE    : OUT    std_logic                     := '0';
      DSRCLK     : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      DWRITE     : OUT    std_logic                     := '0';
      D_A        : OUT    std_logic_vector (3 DOWNTO 0) := (others => '0');
      D_T        : OUT    std_logic_vector (7 DOWNTO 0) := (OTHERS => '0');
      D_T2       : OUT    std_logic_vector (1 DOWNTO 0) := (others => '0');
      EE_CS      : OUT    std_logic;
      GREEN_LED  : OUT    std_logic;
      MOSI       : OUT    std_logic                     := '0';
      OE_ADC     : OUT    STD_LOGIC;
      RED_LED    : OUT    std_logic;
      RS485_C_DE : OUT    std_logic;
      RS485_C_DO : OUT    std_logic;
      RS485_C_RE : OUT    std_logic;
      RS485_E_DE : OUT    std_logic;
      RS485_E_DO : OUT    std_logic;
      RS485_E_RE : OUT    std_logic;
      RSRLOAD    : OUT    std_logic                     := '0';
      SRIN       : OUT    std_logic                     := '0';
      S_CLK      : OUT    std_logic;
      TCS        : OUT    std_logic_vector (3 DOWNTO 0);
      TRG_V      : OUT    std_logic;
      W_A        : OUT    std_logic_vector (9 DOWNTO 0);
      W_CS       : OUT    std_logic                     := '1';
      W_RD       : OUT    std_logic                     := '1';
      W_RES      : OUT    std_logic                     := '1';
      W_WR       : OUT    std_logic                     := '1';
      MISO       : INOUT  std_logic;
      W_D        : INOUT  std_logic_vector (15 DOWNTO 0)
   );

-- Declarations

END FAD_Board ;

--
-- VHDL Architecture FACT_FAD_lib.FAD_Board.struct
--
-- Created:
--          by - dneise.UNKNOWN (E5B-LABOR6)
--          at - 17:38:00 16.02.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.2 (Build 10)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.NUMERIC_STD.all;
USE ieee.std_logic_unsigned.all;

LIBRARY FACT_FAD_lib;
USE FACT_FAD_lib.fad_definitions.all;

LIBRARY FACT_FAD_lib;

ARCHITECTURE struct OF FAD_Board IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL CLK_25_PS             : std_logic;
   SIGNAL CLK_25_PS1            : std_logic;
   SIGNAL CLK_50                : std_logic;
   SIGNAL SRCLK                 : std_logic                     := '0';
   SIGNAL adc_clk_en            : std_logic                     := '0';
   SIGNAL adc_data_array        : adc_data_array_type;
   SIGNAL alarm_refclk_too_high : std_logic                     := '0';
   SIGNAL alarm_refclk_too_low  : std_logic                     := '0';
   SIGNAL board_id              : std_logic_vector(3 DOWNTO 0);
   SIGNAL counter_result        : std_logic_vector(11 DOWNTO 0) := (others => '0');
   SIGNAL crate_id              : std_logic_vector(1 DOWNTO 0);
   SIGNAL led                   : std_logic_vector(7 DOWNTO 0)  := (OTHERS => '0');


   -- Component Declarations
   COMPONENT FAD_main
   GENERIC (
      RAMADDRWIDTH64b : integer := 12
   );
   PORT (
      CLK                    : IN     std_logic ;
      D_T_in                 : IN     std_logic_vector (1 DOWNTO 0);
      SROUT_in_0             : IN     std_logic ;
      SROUT_in_1             : IN     std_logic ;
      SROUT_in_2             : IN     std_logic ;
      SROUT_in_3             : IN     std_logic ;
      adc_data_array         : IN     adc_data_array_type ;
      adc_otr_array          : IN     std_logic_vector (3 DOWNTO 0);
      board_id               : IN     std_logic_vector (3 DOWNTO 0);
      crate_id               : IN     std_logic_vector (1 DOWNTO 0);
      drs_refclk_in          : IN     std_logic ;                                      -- used TO check if DRS REFCLK exsists, if not DENABLE inhibit
      plllock_in             : IN     std_logic_vector (3 DOWNTO 0);                   -- high level, if dominowave is running and DRS PLL locked
      trigger                : IN     std_logic ;
      wiz_int                : IN     std_logic ;
      CLK_25_PS              : OUT    std_logic ;
      CLK_50                 : OUT    std_logic ;
      RSRLOAD                : OUT    std_logic                      := '0';
      SRCLK                  : OUT    std_logic                      := '0';
      SRIN_out               : OUT    std_logic                      := '0';
      adc_clk_en             : OUT    std_logic                      := '0';
      adc_oeb                : OUT    std_logic                      := '1';
      additional_flasher_out : OUT    std_logic ;
      alarm_refclk_too_high  : OUT    std_logic                      := '0';           -- default domino wave off
      alarm_refclk_too_low   : OUT    std_logic                      := '0';           -- default domino wave off
      amber                  : OUT    std_logic ;
      counter_result         : OUT    std_logic_vector (11 DOWNTO 0) := (others => '0');
      dac_cs                 : OUT    std_logic ;
      denable                : OUT    std_logic                      := '0';           -- default domino wave off
      drs_channel_id         : OUT    std_logic_vector (3 DOWNTO 0)  := (others => '0');
      drs_dwrite             : OUT    std_logic                      := '1';
      green                  : OUT    std_logic ;
      led                    : OUT    std_logic_vector (7 DOWNTO 0)  := (OTHERS => '0');
      mosi                   : OUT    std_logic                      := '0';
      red                    : OUT    std_logic ;
      sclk                   : OUT    std_logic ;
      sensor_cs              : OUT    std_logic_vector (3 DOWNTO 0);
      wiz_addr               : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_cs                 : OUT    std_logic                      := '1';
      wiz_rd                 : OUT    std_logic                      := '1';
      wiz_reset              : OUT    std_logic                      := '1';
      wiz_wr                 : OUT    std_logic                      := '1';
      sio                    : INOUT  std_logic ;
      wiz_data               : INOUT  std_logic_vector (15 DOWNTO 0)
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   FOR ALL : FAD_main USE ENTITY FACT_FAD_lib.FAD_main;
   -- pragma synthesis_on


BEGIN
   -- Architecture concurrent statements
   -- HDL Embedded Text Block 1 SRCLK
   DSRCLK <= ( SRCLK, SRCLK,SRCLK,SRCLK);

   -- HDL Embedded Text Block 2 ADC_CLK
   A_CLK <= (CLK_25_PS, CLK_25_PS, CLK_25_PS, CLK_25_PS);

   -- HDL Embedded Text Block 3 ADC_DATA
   adc_data_array <= ( A0_D, A1_D, A2_D, A3_D );

   -- HDL Embedded Text Block 4 eb_ID
   -- hard-wired IDs
   board_id <= LINE(5 downto 2);
   crate_id <= LINE(1 downto 0);

   -- HDL Embedded Text Block 9 eb3
   -- testpins D_T2 are used as MAX3485 outputs.
   
   --D_T <= (others => '0');
   --D_T2 <= ( others => '0' );
   -- A0_T(7 downto 0) <= (others => '0');
   --A1_T(7 downto 0) <= (others => '0');
   
   A1_T <= counter_result ( 7 downto 0);
   D_T(3 downto 0) <=  counter_result ( 11 downto 8);
   D_T(4) <= alarm_refclk_too_low;
   D_T(5) <= alarm_refclk_too_high;
   D_T(6) <= '0';
   D_T(7) <= '0';
   
   -- led output is driven by w5300 modul 
   -- for debugging only.
   A0_T <= led;
   
   -- MAX3485 for FTM trigger ID is switched into receive mode
   RS485_E_RE <= '0';
   RS485_E_DE <= '0';
   -- in receive mode, the DI input of this MAX is in 'don't care' state
   RS485_E_DO <= '0';
   -- the receive pin is fed out as well
   D_T2(1) <= RS485_E_DI; 
   
   -- additional MAX3485 is switched to shutdown mode
   RS485_C_RE <= '1';  --inverted logic
   RS485_C_DE <= '0';   
   RS485_C_DO <= '0';
   -- MAX3485 receiver out pit is fed out... should be HIGH-Z
   D_T2(0) <= RS485_C_DI; 
   
   -- EEPROM is not used on FAD. CS is always high.
   EE_CS <= '1';


   -- ModuleWare code(v1.9) for instance 'I0' of 'and'
   CLK_25_PS <= adc_clk_en AND CLK_25_PS1;

   -- Instance port mappings.
   I_board_main : FAD_main
      GENERIC MAP (
         RAMADDRWIDTH64b => LOG2_OF_RAM_SIZE_64B
      )
      PORT MAP (
         CLK                    => X_50M,
         D_T_in                 => D_T_in,
         SROUT_in_0             => D0_SROUT,
         SROUT_in_1             => D1_SROUT,
         SROUT_in_2             => D2_SROUT,
         SROUT_in_3             => D3_SROUT,
         adc_data_array         => adc_data_array,
         adc_otr_array          => A_OTR,
         board_id               => board_id,
         crate_id               => crate_id,
         drs_refclk_in          => REFCLK,
         plllock_in             => D_PLLLCK,
         trigger                => TRG,
         wiz_int                => W_INT,
         CLK_25_PS              => CLK_25_PS1,
         CLK_50                 => CLK_50,
         RSRLOAD                => RSRLOAD,
         SRCLK                  => SRCLK,
         SRIN_out               => SRIN,
         adc_clk_en             => adc_clk_en,
         adc_oeb                => OE_ADC,
         additional_flasher_out => TRG_V,
         alarm_refclk_too_high  => alarm_refclk_too_high,
         alarm_refclk_too_low   => alarm_refclk_too_low,
         amber                  => AMBER_LED,
         counter_result         => counter_result,
         dac_cs                 => DAC_CS,
         denable                => DENABLE,
         drs_channel_id         => D_A,
         drs_dwrite             => DWRITE,
         green                  => RED_LED,
         led                    => led,
         mosi                   => MOSI,
         red                    => GREEN_LED,
         sclk                   => S_CLK,
         sensor_cs              => TCS,
         wiz_addr               => W_A,
         wiz_cs                 => W_CS,
         wiz_rd                 => W_RD,
         wiz_reset              => W_RES,
         wiz_wr                 => W_WR,
         sio                    => MISO,
         wiz_data               => W_D
      );

END struct;
