--
-- VHDL Architecture FACT_FAD_lib.rs485_receiver.beha
--
-- Created:
--          by - Benjamin Krumm.UNKNOWN (EEPC8)
--          at - 12:16:57 11.06.2010
--
-- using Mentor Graphics HDL Designer(TM) 2009.2 (Build 10)
--
--
-- modified for FTU and FTM design by Q. Weitzel, 13 September 2010
-- timeout replaced by reset by Q. Weitzel, 04 February 2011
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

library ftm_definitions;
USE ftm_definitions.ftm_constants.all;

ENTITY FTM_ftu_rs485_receiver IS
  generic(
    RX_BYTES  : integer := FTU_RS485_BLOCK_WIDTH / 8; -- no. of bytes to receive
    RX_WIDTH  : integer := FTU_RS485_BLOCK_WIDTH
  );
  port(
    rec_clk   : in  std_logic;
    rec_reset : in  std_logic;
    --rx_busy   : in  std_logic;
    rec_din   : in  std_logic_vector(7 downto 0);
    rec_den   : in  std_logic;
    rec_dout  : out std_logic_vector(RX_WIDTH - 1 downto 0) := (others => '0');
    rec_valid : out std_logic := '0'
  );
END ENTITY FTM_ftu_rs485_receiver;

ARCHITECTURE beha OF FTM_ftu_rs485_receiver IS
  
  signal rxcnt : integer range 0 to RX_BYTES := 0;
  signal rxsr  : std_logic_vector(3 downto 0) := (others => '0');
  
BEGIN
  
  rx_data_proc : process(rec_clk)
  begin
    if rising_edge(rec_clk) then
      rxsr <= rxsr(2 downto 0) & rec_den;
      if (rec_reset = '1') then
        rec_dout <= (others => '0');
        rxcnt <= 0;
        rec_valid <= '0';
      else        
        if (rxsr(3 downto 2) = "01") then -- identify rising edge
          rec_dout((rxcnt*rec_din'length + rec_din'length - 1) downto (rxcnt*rec_din'length)) <= rec_din;
          rxcnt <= rxcnt + 1;
          if (rxcnt < RX_BYTES - 1) then
            rec_valid <= '0';
          else
            rxcnt <= 0;
            rec_valid <= '1';
          end if;
        end if;
      end if;
    end if;
  end process rx_data_proc;
  
END ARCHITECTURE beha;
