library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.all;

ENTITY w5300_modul IS
PORT(
	clk							: IN	std_logic;						-- expecting 50MHz
	
	wiz_reset_o					: OUT	std_logic						:= '1';
	cs_o						: OUT	std_logic						:= '1';
	wr_o						: OUT	std_logic						:= '1';
	rd_o						: OUT	std_logic						:= '1';
	int_o						: IN	std_logic;
	wiz_data					: INOUT	std_logic_vector (15 DOWNTO 0);
	wiz_addr					: OUT	std_logic_vector (9 DOWNTO 0);
	
	read_not_wirte				: IN	std_logic;
	start_i						: IN	std_logic;
	valid_next					: OUT	std_logic						:='0';
	addr_i						: IN	std_logic_vector (9 DOWNTO 0);
	data_o						: OUT	std_logic_vector (15 DOWNTO 0)	:= (others => '0');
	data_i						: IN	std_logic_vector (15 DOWNTO 0);
	
);
END w5300_modul ;

architecture Behavioral of w5300_modul is
	signal read_not_write_signal : std_logic := '1';
	signal data_signal : std_logic_vector (15 DOWNTO 0) := (others => 'Z');
	signal addr_signal : std_logic_vector (9 DOWNTO 0) := (others => '0');
	
main_process: process(clk)
begin

rd_o <= read_not_write_signal;
wr_o <= not read_not_write_signal;
wiz_data <= data_signal;
wiz_addr <= addr_signal;

if rising__edge(clk) then

	case state is
	
	when BEFORE DO SOMETING		=>
		
	when CS_LOW	=>
		cs_o <= '0';
		state <= WAIT_ONCE;
		
	when AFTER_20ns	=>
		state <= WAIT_TWICE;
		
	when AFTER_40ns	=>
		if (read_not_write_signal = '1') then
			valid_next <= '1';
			state <= OUTPUT_DATA;
		else
			state <= INPUT_SAMPLING;
		end if;
		
		
		state <= DO_SOMETHING_ELSE;
		
	when OUTPUT_DATA	=>
		
		if (read_not_write_signal = '1') then
			data_o <= wiz_data;
		end if;
		
	when INPUT_SAMPLING	=>
		cs_o <= '1';
		addr_signal <= addr_i;
		read_not_write_signal <= read_not_write;
		if (read_not_write = '1') then
			data_signal <= (others => 'Z');
		else
			data_signal <= data_i;
		end if;
		wiz_addr <= addr_i;
	
		if (start_i = '1') then
			idle_next = '0';
			state <= CS_LOW;
		else
			state <= INPUT_SAMPLING;
	
					when READ_REG =>
						case count is
							when "000" =>
								cs <= '0';
								rd <= '0';
								wr <= '1';
								data <= (others => 'Z'); -- !!!!!!!!!!
								count <= "001";
								addr <= par_addr;
							
							1x WARTEN
							
							1x WARTEN
							
							when "100" =>
								data_read <= data;
								count <= "110";
							
							1x WARTEN
							
							when "111" =>
								cs <= '1';
								rd <= '1';
								count <= "000";
								state_init <= next_state;

					when WRITE_REG =>
						case count is
							when "000" =>
								cs <= '0';
								wr <= '0';
								rd <= '1';
								addr <= par_addr; 
								if (ram_access = '1') then
									data <= ram_data;
								else
									data <= par_data;
								end if;
								count <= "100";
							
							1x WARTEN
							
							1x WARTEN
							
							when "110" =>
								cs <= '1';
								wr <= '1';
								state_init <= next_state;
								count <= "000";
							when others =>
								null;
						end case;
					
					when others =>
						null;
enf if; -- rising_edge(clk)						
end process main_process;