#ifndef FADFORMAT_H_SEEN
#define FADFORMAT_H_SEEN

#include "../drsdaq/RawDataCTX.h"

//
// Commands for FAD
//
#define CMD_Start 0x2200						// Start Run
#define CMD_Stop 0x2300							// Stop Run
#define CMD_mode_command 0x3000 		// Set Socket mode to: command mode
#define CMD_mode_all_sockets 0x3100// Set Socket mode to: daq mode

#define CMD_Trigger 0xA000 		// single trigger
#define CMD_DENABLE 0x0600      // DENABLE line HIGH
#define CMD_DDISABLE 0x0700     // DENABLE line LOW
#define CMD_DWRITE_RUN 0x0800   // DWRITE possibly HIGH
#define CMD_DWRITE_STOP 0x0900  // DWRITE always LOW
#define CMD_SCLK_ON 0x1000  
#define CMD_SCLK_OFF 0x1100
#define CMD_PS_DIRINC 0x1200
#define CMD_PS_DIRDEC 0x1300
#define CMD_PS_DO 0x1400
#define CMD_PS_RESET 0x1700
#define CMD_SRCLK_ON 0x1500
#define CMD_SRCLK_OFF 0x1600
#define CMD_Trigger_C 0xB000 	// continous trigger
#define CMD_Trigger_S 0x2000 	// stop continous trigger
#define CMD_Read 0x0A00 		// read from Config-RAM
#define CMD_Write 0x0500 		// write to Config-RAM

#define CMD_TRIGGERS_ON 0x1800	// enables the trigger line -- incoming triggers can now be accepted
#define CMD_TRIGGERS_OFF 0x1900 // disables the trigger line -- no trigger will be accepted

//
// Other definitions
//
#define MAX_ADDR 0xFF // highest address in Config-RAM
#define BADDR_ROI 0x00 // Baseaddress ROI-Values
#define BADDR_DAC 0x24 // Baseaddress DAC-Values
#define MAX_VAL 65535
#define MAX_ROIVAL 1024
#define MAX_DACVAL 65535

const unsigned int NChannels	= 9;
const unsigned int NBins		= 1024;
const unsigned int NChips 		= 4;
const unsigned int NTemp		= 4;
const unsigned int NDAC			= 8;

//
// Data structures
//
typedef struct {
// ------------------------------
uint16_t start_package_flag;
uint16_t package_length;
uint16_t version_no;
uint16_t PLLLCK;
// ------------------------------
uint16_t trigger_crc;
uint16_t trigger_type;
uint32_t trigger_id;
// ------------------------------
uint32_t fad_evt_counter;
uint32_t REFCLK_frequency;
// ------------------------------
uint16_t board_id;
uint16_t adc_clock_phase_shift;
uint16_t number_of_triggers_to_generate;
uint16_t trigger_generator_prescaler;
// ------------------------------
uint8_t DNA[8]; // Xilinx DNA
// ------------------------------
uint32_t time;
uint32_t fad_status;
// ------------------------------
int16_t drs_temperature[NTemp];
// ------------------------------
uint16_t dac[NDAC];
// ------------------------------
} __attribute__((__packed__)) PEVNT_HEADER;
typedef struct {
uint16_t id;
uint16_t start_cell;
uint16_t roi;
uint16_t filling;
uint16_t adc_data[];
} __attribute__((__packed__)) PCHANNEL;
typedef struct {
uint16_t package_crc;
uint16_t end_package_flag;
} __attribute__((__packed__)) PEVNT_FOOTER;

#endif
