#ifndef FAD_H_SEEN
#define FAD_H_SEEN

#define SERVER_NAME "FADctrl"       // Name to use in DIM
#include "Evidence.h"

#include <readline/readline.h>

#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <time.h>
#include <math.h>
#include <errno.h>
#include <unistd.h>
#include <dirent.h>
#include <sys/time.h>
#include <limits>
#include <fcntl.h>

#include "FADBoard.h"
#include "../drsdaq/RawDataCTX.h"

const unsigned int PORT = 5000;
const int DEFAULT_NUM_CALIB_EVENTS = 100;
const char CALIB_DIRECTORY[] = "~/";


class FAD: public EvidenceServer {

  public:
    enum ModeType {idle, datarun, acalib};
	ModeType Mode;

  private:
	pthread_t MainThread;
	DimCommand *Command;
	DimService *ConsoleOut;
	char *ConsoleText;
	std::vector<std::string> Parameter;
    void PrintUsage();
	void commandHandler();
	virtual void exitHandler(int);
	bool Match(std::string, const char *);
	void EventThread();
	static void LaunchEventThread(class FAD *);
	pthread_t Thread;
	float EventUpdateDelay;

    int Datafile;
    int NumEvents;			// Number of event taken            
	
	std::vector<class FADBoard *> Boards;

	struct Range {
	  int Min;
	  int Max;
	};

	void ExecuteCommand();
	bool ConvertToDouble(std::string, double *);
	bool ConvertToInt(std::string, int *);
	bool ConvertToRange(std::string, struct Range &);

  public:
    FAD(std::vector<std::string>);
    ~FAD();

	void cmd_exit();		void cmd_help();
	void cmd_board();		void cmd_status();
	void cmd_acalib();		void cmd_serial();
	void cmd_trigger(); 	
void cmd_socketmode();void cmd_daqmode();  
	void cmd_srclk();		void cmd_sclk();
	void cmd_dwrite();		void cmd_domino();
	void cmd_wmode();		void cmd_rmode();
	void cmd_dmode();		void cmd_dac();
	void cmd_roi();			void cmd_address();
	void cmd_phase();		void cmd_send();
	void cmd_stop();		void cmd_update();
	void cmd_take();		void cmd_reconnect();

    void EnableDomino();
    void DisableDomino();
    void SoftTrigger();
    //void SetDOMINOMode(int);
    //void SetDOMINOReadMode(int);
    //void SetDOMINOWaveMode(int);
	void SaveAmplitudeCalibration();
    void PrintMessage(const char*, ...);
	
	int Pipe[2];
    int NumEventsRequested;	// Number of events requested
	std::vector<std::string> BoardList;
};

#endif
