----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       Q. Weitzel
-- 
-- Create Date:    15:56:13 02/28/2011 
-- Design Name: 
-- Module Name:    FTM_central_control - Behavioral 
-- Project Name: 
-- Target Devices: 
-- Tool versions: 
-- Description:    Central FSM for FTM firmware
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity FTM_central_control is
  port(
    clk                  : IN  std_logic;
    new_config           : IN  std_logic;
    config_started       : OUT std_logic := '0';
    config_started_ack   : IN  std_logic;
    config_start_eth     : OUT std_logic := '0';
    config_started_eth   : IN  std_logic;
    config_ready_eth     : IN  std_logic;
    config_start_ftu     : OUT std_logic := '0';
    config_started_ftu   : IN  std_logic ;
    config_ready_ftu     : IN  std_logic ;
    ping_ftu_start       : IN  std_logic;
    ping_ftu_started     : OUT std_logic := '0';
    ping_ftu_ready       : OUT std_logic := '0';
    ping_ftu_start_ftu   : OUT std_logic := '0';
    ping_ftu_started_ftu : IN  std_logic;
    ping_ftu_ready_ftu   : IN  std_logic
  );
end FTM_central_control;

architecture Behavioral of FTM_central_control is

  type state_central_proc_type is (CP_INIT, CP_CONFIG_START, CP_CONFIG, CP_CONFIG_01,
                                   CP_CONFIG_FTU, CP_CONFIG_FTU_01,
                                   CP_IDLE, CP_PING);
  signal state_central_proc : state_central_proc_type := CP_INIT;
  
begin

  central_proc : process (clk)
  begin
    if rising_edge (clk) then
      case state_central_proc is

        when CP_INIT =>
          state_central_proc <= CP_CONFIG;
          
        when CP_CONFIG_START =>
          if (config_started_ack = '1') then
            config_started <= '0';
            state_central_proc <= CP_CONFIG;
          end if;

        when CP_CONFIG =>
          config_start_eth <= '1';
          if (config_started_eth = '1') then
            config_start_eth <= '0';
            state_central_proc <= CP_CONFIG_01;
          end if;

        when CP_CONFIG_01 =>
          if (config_ready_eth = '1') then
            state_central_proc <= CP_CONFIG_FTU;
          end if;

        when CP_CONFIG_FTU =>
          config_start_ftu <= '1';
          if (config_started_ftu = '1') then
            config_start_ftu <= '0';
            state_central_proc <= CP_CONFIG_FTU_01;
          end if;

        when CP_CONFIG_FTU_01 =>
          if (config_ready_ftu = '1') then
            state_central_proc <= CP_IDLE;
          end if;
          
        when CP_IDLE =>
          if (new_config = '1') then
            config_started <= '1';
            state_central_proc <= CP_CONFIG_START;

          elsif (ping_ftu_start = '1') then
            ping_ftu_start_ftu <= '1';
            if (ping_ftu_started_ftu = '1') then
              ping_ftu_start_ftu <= '0';
              ping_ftu_started <= '1';
              ping_ftu_ready <= '0';
              state_central_proc <= CP_PING;
            end if;

          end if;

        when CP_PING =>
          if (ping_ftu_ready_ftu = '1') then
            if (ping_ftu_start = '0') then
              ping_ftu_started <= '0';
              ping_ftu_ready <= '1';
              state_central_proc <= CP_IDLE;
            end if;
          end if;

      end case;
    end if;
  end process central_proc;

end Behavioral;
