--
-- VHDL Architecture FACT_FTM_lib.dram_control.beha
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 11:39:22 23.02.2011
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.STD_LOGIC_UNSIGNED.all;
-- LIBRARY FACT_FTM_lib;
-- USE FACT_FTM_lib.ftm_array_types.all;
-- USE FACT_FTM_lib.ftm_constants.all;
library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;

ENTITY dram_control IS
   PORT( 
	clk            			: IN	std_logic;
	dram_data_in   			: OUT	std_logic_vector (15 DOWNTO 0);
	dram_data_out  			: IN	std_logic_vector (15 DOWNTO 0);
	dram_addr_in   			: OUT	std_logic_vector (11 DOWNTO 0);
	dram_addr_out  			: OUT	std_logic_vector (11 DOWNTO 0);
	dram_we        			: OUT	std_logic_vector (0 DOWNTO 0) := "0";
	dd_block_start 			: IN	std_logic;
	dd_block_start_ftu 		: IN	std_logic;
	dd_block_start_ack 		: OUT	std_logic := '0';
	dd_block_start_ack_ftu 	: OUT	std_logic := '0';
	dd_block_ready 			: IN	std_logic;
	dd_block_ready_ftu 		: IN	std_logic;
	dd_read        			: IN	std_logic;
	dd_write_ftu   			: IN	std_logic;
	dd_busy        			: OUT	std_logic := '1';
	dd_started     			: OUT	std_logic := '0';
	dd_started_ftu 			: OUT	std_logic := '0';
	dd_ready       			: OUT	std_logic := '0';
	dd_data_out    			: OUT	std_logic_vector (15 DOWNTO 0) := (others => '0');
	dd_data_in_ftu 			: IN	std_logic_vector (15 DOWNTO 0);
	dd_addr        			: IN	std_logic_vector (11 DOWNTO 0);
	dd_addr_ftu    			: IN	std_logic_vector (11 DOWNTO 0)
   );

-- Declarations

END dram_control ;

--
ARCHITECTURE beha OF dram_control IS
  
  type state_dram_proc_type is (DR_INIT, DR_CONFIG, DR_IDLE, DR_DOUT_WIZ_START, DR_DOUT_WIZ_END, DR_WRITE_START, DR_WRITE_END,
                                DR_READ_START, DR_READ_WAIT, DR_READ_END);
  type state_dd_block_proc_type is (DD_BLOCK_IDLE, DD_BLOCK_WAIT_WIZ, DD_BLOCK_WAIT_FTU);

                                
  signal state_dram_proc  : state_dram_proc_type := DR_INIT;
  signal next_state       : state_dram_proc_type := DR_IDLE;
  
  signal state_dd_block_proc : state_dd_block_proc_type := DD_BLOCK_IDLE;

  signal local_addr  : std_logic_vector (11 downto 0) := X"000";
  signal local_data  : std_logic_vector (15 downto 0);
 
BEGIN

  dd_block_proc : process (clk)
  begin
	if rising_edge (clk) then
	  case state_dd_block_proc is

		when DD_BLOCK_IDLE =>
		  if (dd_block_start = '1') then
			dd_block_start_ack <= '1';
			state_dd_block_proc <= DD_BLOCK_WAIT_WIZ;
		  elsif (dd_block_start_ftu = '1') then
			dd_block_start_ack_ftu <= '1';
			state_dd_block_proc <= DD_BLOCK_WAIT_FTU;
		  end if;

		when DD_BLOCK_WAIT_WIZ =>
		  if (dd_block_ready = '1') then
			dd_block_start_ack <= '0';
			state_dd_block_proc <= DD_BLOCK_IDLE;
		  end if;

		when DD_BLOCK_WAIT_FTU =>
		  if (dd_block_ready_ftu = '1') then
			dd_block_start_ack_ftu <= '0';
			state_dd_block_proc <= DD_BLOCK_IDLE;
		  end if;

	  end case;
	end if;
  end process dd_block_proc;

  dram_proc : process (clk)
  begin
    if rising_edge (clk) then
      case state_dram_proc is

        when DR_INIT =>
          state_dram_proc <= DR_CONFIG;

        when DR_CONFIG =>
          state_dram_proc <= DR_IDLE;
          
        when DR_IDLE =>
          dd_busy <= '0';
          
          if (dd_read = '1') then
            dd_busy <= '1';
            dd_started <= '1';
            dd_ready <= '0';
            local_addr <= dd_addr;
            next_state <= DR_DOUT_WIZ_START;
            state_dram_proc <= DR_READ_START;
            
          elsif (dd_write_ftu = '1') then
            dd_busy <= '1';
            dd_started_ftu <= '1';
            dd_ready <= '0';
            local_addr <= dd_addr_ftu;
            local_data <= dd_data_in_ftu;
            next_state <= DR_IDLE;
            state_dram_proc <= DR_WRITE_START;
          end if;



        when DR_DOUT_WIZ_START =>
          dd_data_out <= local_data;
          dd_ready <= '1';
          state_dram_proc <= DR_DOUT_WIZ_END;
          
        when DR_DOUT_WIZ_END =>
          if (dd_read <= '0') then
            dd_started <= '0';
            state_dram_proc <= DR_IDLE;
          end if;

        -- --
        -- write to dynamic data ram
        -- --
        when DR_WRITE_START =>
          dram_addr_in <= local_addr;
          dram_data_in <= local_data;
          dram_we <= "1";
          state_dram_proc <= DR_WRITE_END;
          
        when DR_WRITE_END =>
          dram_we <= "0";
          dd_started_ftu <= '0';
          dd_ready <= '1';
          state_dram_proc <= next_state;

        -- --
        -- read from dynamic data ram
        -- --
        when DR_READ_START =>
          dram_addr_out <= local_addr;
          state_dram_proc <= DR_READ_WAIT;
          
        when DR_READ_WAIT =>
          state_dram_proc <= DR_READ_END;
          
        when DR_READ_END =>
          local_data <= dram_data_out;
          state_dram_proc <= next_state;


      end case;
    end if; -- rising edge
  end process dram_proc;

END ARCHITECTURE beha;
