--
-- VHDL Architecture FACT_FTM_lib.eth_config_modul.beha
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 14:52:32 15.02.2011
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.STD_LOGIC_UNSIGNED.all;
-- LIBRARY FACT_FTM_lib;
-- USE FACT_FTM_lib.ftm_array_types.all;
-- USE FACT_FTM_lib.ftm_constants.all;
library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;

ENTITY eth_config_modul IS
  PORT(
    clk                 : IN std_logic;
    config_start_eth    : IN std_logic;
    config_started_eth  : OUT std_logic := '0';
    config_ready_eth    : OUT std_logic := '0';
    
    config_start_cc     : OUT std_logic := '0';
    config_started_cc   : IN std_logic;
    config_ready_cc     : IN std_logic
  );
END ENTITY eth_config_modul;

--
ARCHITECTURE beha OF eth_config_modul IS
  
  type state_config_proc_type is (CP_IDLE, CP_CONFIG_START, CP_CONFIG_01, CP_CONFIG_END);
  signal state_config_proc : state_config_proc_type := CP_IDLE; 
  
BEGIN
  
  config_proc : process (clk)
  begin
    if rising_edge (clk) then
      case state_config_proc is
        
        when CP_IDLE =>
          if (config_start_eth = '1') then
            config_ready_eth <= '0';
            config_started_eth <= '1';
            state_config_proc <= CP_CONFIG_START;
          end if;
          
        when CP_CONFIG_START =>
          config_start_cc <= '1';
          if (config_started_cc = '1') then
            config_start_cc <= '0';
            state_config_proc <= CP_CONFIG_01;
          end if;
          
        when CP_CONFIG_01 =>
          if (config_ready_cc = '1') then
            state_config_proc <= CP_CONFIG_END;
          end if;
          
        when CP_CONFIG_END =>
          config_started_eth <= '0';
          config_ready_eth <= '1';
          state_config_proc <= CP_IDLE;
          
        
      end case;
    end if;
  end process config_proc;

END ARCHITECTURE beha;

