-- VHDL Entity FACT_FTM_lib.ethernet_modul.symbol
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 11:17:45 25.02.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
--LIBRARY FACT_FTM_lib;
library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;

ENTITY ethernet_modul IS
   PORT( 
      wiz_reset          : OUT    std_logic                      := '1';
      wiz_addr           : OUT    std_logic_vector (9 DOWNTO 0);
      wiz_data           : INOUT  std_logic_vector (15 DOWNTO 0);
      wiz_cs             : OUT    std_logic                      := '1';
      wiz_wr             : OUT    std_logic                      := '1';
      wiz_rd             : OUT    std_logic                      := '1';
      wiz_int            : IN     std_logic;
      clk                : IN     std_logic;
      sd_ready           : OUT    std_logic;
      sd_busy            : OUT    std_logic;
      led                : OUT    std_logic_vector (7 DOWNTO 0);
      sd_read_ftu        : IN     std_logic;
      sd_started_ftu     : OUT    std_logic                      := '0';
      cc_R0              : OUT    std_logic_vector (31 DOWNTO 0);
      cc_R1              : OUT    std_logic_vector (31 DOWNTO 0);
      cc_R11             : OUT    std_logic_vector (31 DOWNTO 0);
      cc_R13             : OUT    std_logic_vector (31 DOWNTO 0);
      cc_R14             : OUT    std_logic_vector (31 DOWNTO 0);
      cc_R15             : OUT    std_logic_vector (31 DOWNTO 0);
      cc_R8              : OUT    std_logic_vector (31 DOWNTO 0);
      cc_R9              : OUT    std_logic_vector (31 DOWNTO 0);
      coin_n_c           : OUT    std_logic_vector (15 DOWNTO 0);
      coin_n_p           : OUT    std_logic_vector (15 DOWNTO 0);
      dead_time          : OUT    std_logic_vector (15 DOWNTO 0);
      -- data from config ram
      general_settings   : OUT    std_logic_vector (15 DOWNTO 0);
      lp1_amplitude      : OUT    std_logic_vector (15 DOWNTO 0);
      lp1_delay          : OUT    std_logic_vector (15 DOWNTO 0);
      lp2_amplitude      : OUT    std_logic_vector (15 DOWNTO 0);
      lp2_delay          : OUT    std_logic_vector (15 DOWNTO 0);
      lp_pt_freq         : OUT    std_logic_vector (15 DOWNTO 0);
      lp_pt_ratio        : OUT    std_logic_vector (15 DOWNTO 0);
      timemarker_delay   : OUT    std_logic_vector (15 DOWNTO 0);
      trigger_delay      : OUT    std_logic_vector (15 DOWNTO 0);
      sd_addr_ftu        : IN     std_logic_vector (11 DOWNTO 0);
      sd_data_out_ftu    : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      ftu_active_cr0     : OUT    std_logic_vector (15 DOWNTO 0);
      ftu_active_cr1     : OUT    std_logic_vector (15 DOWNTO 0);
      ftu_active_cr2     : OUT    std_logic_vector (15 DOWNTO 0);
      ftu_active_cr3     : OUT    std_logic_vector (15 DOWNTO 0);
      new_config         : OUT    std_logic                      := '0';
      config_started     : IN     std_logic;
      config_start_eth   : IN     std_logic;
      config_started_eth : OUT    std_logic                      := '0';
      config_ready_eth   : OUT    std_logic                      := '0';
      config_started_ack : OUT    std_logic                      := '0';
      fl_busy            : OUT    std_logic;
      fl_ready           : OUT    std_logic;
      fl_write_ftu       : IN     std_logic;
      fl_started_ftu     : OUT    std_logic                      := '0';
      fl_addr_ftu        : IN     std_logic_vector (11 DOWNTO 0);
      fl_data_in_ftu     : IN     std_logic_vector (15 DOWNTO 0) := (others => '0');
      --
      ping_ftu_start     : OUT    std_logic                      := '0';
      ping_ftu_started   : IN     std_logic;
      ping_ftu_ready     : IN     std_logic;
      dd_write_ftu       : IN     std_logic;
      dd_started_ftu     : OUT    std_logic                      := '0';
      dd_data_in_ftu     : IN     std_logic_vector (15 DOWNTO 0);
      dd_addr_ftu        : IN     std_logic_vector (11 DOWNTO 0);
      dd_busy            : OUT    std_logic;
      dd_ready           : OUT    std_logic;
      coin_win_c         : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      coin_win_p         : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0')
   );

-- Declarations

END ethernet_modul ;

--
-- VHDL Architecture FACT_FTM_lib.ethernet_modul.beha
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 11:17:46 25.02.2011
--
-- Generated by Mentor Graphics' HDL Designer(TM) 2009.1 (Build 12)
--
-- 
-- 
--LIBRARY IEEE;
--USE IEEE.STD_LOGIC_1164.all;
--USE IEEE.STD_LOGIC_ARITH.all;
--USE IEEE.STD_LOGIC_UNSIGNED.all;
--LIBRARY FACT_FTM_lib;
--USE FACT_FTM_lib.ftm_array_types.all;
--USE FACT_FTM_lib.ftm_constants.all;

--LIBRARY FACT_FTM_lib;

ARCHITECTURE beha OF ethernet_modul IS

   -- Architecture declarations

   -- Internal signal declarations
   SIGNAL busy                   : std_logic                     := '1';
   SIGNAL cram_data_out          : std_logic_vector(15 DOWNTO 0);
   SIGNAL cram_data_in           : std_logic_vector(15 DOWNTO 0);
   SIGNAL cram_we                : std_logic_vector(0 DOWNTO 0)  := "0";
   SIGNAL sd_write               : std_logic                     := '0';
   SIGNAL sd_read                : std_logic;
   SIGNAL led1                   : std_logic_vector(7 DOWNTO 0)  := (others => '0');
   SIGNAL sd_started             : std_logic;
   SIGNAL sd_addr                : std_logic_vector(11 DOWNTO 0);
   SIGNAL cram_addr_out          : std_logic_vector(11 DOWNTO 0);
   SIGNAL cram_addr_in           : std_logic_vector(11 DOWNTO 0);
   SIGNAL sd_data_in             : std_logic_vector(15 DOWNTO 0) := (others => '0');
   SIGNAL sd_data_out            : std_logic_vector(15 DOWNTO 0);
   SIGNAL config_ready_cc        : std_logic                     := '0';
   SIGNAL config_started_cc      : std_logic                     := '0';
   SIGNAL config_start_cc        : std_logic;
   SIGNAL fl_started             : std_logic;
   SIGNAL fl_read                : std_logic                     := '0';
   --
   SIGNAL fl_addr                : std_logic_vector(11 DOWNTO 0);
   SIGNAL fl_data_out            : std_logic_vector(15 DOWNTO 0);
   SIGNAL fram_addr_out          : std_logic_vector(11 DOWNTO 0);
   SIGNAL doutb                  : std_logic_VECTOR(15 DOWNTO 0);
   SIGNAL fram_we                : std_logic_vector(0 DOWNTO 0)  := "0";
   SIGNAL fram_addr_in           : std_logic_vector(11 DOWNTO 0);
   SIGNAL fram_data_in           : std_logic_vector(15 DOWNTO 0);
   SIGNAL led2                   : std_logic_vector(7 DOWNTO 0)  := X"00";
   SIGNAL dram_addr_out          : std_logic_vector(11 DOWNTO 0);
   SIGNAL doutb1                 : std_logic_VECTOR(15 DOWNTO 0);
   SIGNAL dram_we                : std_logic_vector(0 DOWNTO 0)  := "0";
   SIGNAL dram_addr_in           : std_logic_vector(11 DOWNTO 0);
   SIGNAL dram_data_in           : std_logic_vector(15 DOWNTO 0);
   SIGNAL dd_read                : std_logic;
   SIGNAL dd_started             : std_logic                     := '0';
   SIGNAL dd_data_out            : std_logic_vector(15 DOWNTO 0) := (others => '0');
   SIGNAL dd_addr                : std_logic_vector(11 DOWNTO 0);
   SIGNAL dd_block_ready         : std_logic                     := '0';
   --
   SIGNAL dd_block_start         : std_logic                     := '0';
   SIGNAL dd_block_start_ack     : std_logic;
   SIGNAL dd_block_ready_ftu     : std_logic;
   SIGNAL dd_block_start_ack_ftu : std_logic                     := '0';
   SIGNAL dd_block_start_ftu     : std_logic;

   -- Implicit buffer signal declarations
   SIGNAL dd_busy_internal  : std_logic;
   SIGNAL dd_ready_internal : std_logic;
   SIGNAL fl_busy_internal  : std_logic;
   SIGNAL fl_ready_internal : std_logic;
   SIGNAL sd_busy_internal  : std_logic;
   SIGNAL sd_ready_internal : std_logic;


   -- Component Declarations
   COMPONENT CRAM_4096_16b
   PORT (
      clka  : IN     std_logic ;
      dina  : IN     std_logic_VECTOR (15 DOWNTO 0);
      addra : IN     std_logic_VECTOR (11 DOWNTO 0);
      wea   : IN     std_logic_VECTOR (0 DOWNTO 0);
      clkb  : IN     std_logic ;
      addrb : IN     std_logic_VECTOR (11 DOWNTO 0);
      doutb : OUT    std_logic_VECTOR (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT DRAM_4096_16b
   PORT (
      clka  : IN     std_logic ;
      dina  : IN     std_logic_VECTOR (15 DOWNTO 0);
      addra : IN     std_logic_VECTOR (11 DOWNTO 0);
      wea   : IN     std_logic_VECTOR (0 DOWNTO 0);
      clkb  : IN     std_logic ;
      addrb : IN     std_logic_VECTOR (11 DOWNTO 0);
      doutb : OUT    std_logic_VECTOR (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT FRAM_4096_16b
   PORT (
      clka  : IN     std_logic ;
      dina  : IN     std_logic_VECTOR (15 DOWNTO 0);
      addra : IN     std_logic_VECTOR (11 DOWNTO 0);
      wea   : IN     std_logic_VECTOR (0 DOWNTO 0);
      clkb  : IN     std_logic ;
      addrb : IN     std_logic_VECTOR (11 DOWNTO 0);
      doutb : OUT    std_logic_VECTOR (15 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT cram_control
   PORT (
      clk               : IN     std_logic ;
      led               : OUT    std_logic_vector (7 DOWNTO 0)  := X"00";
      cram_data_in      : OUT    std_logic_vector (15 DOWNTO 0);
      cram_data_out     : IN     std_logic_vector (15 DOWNTO 0);
      cram_addr_in      : OUT    std_logic_vector (11 DOWNTO 0);
      cram_addr_out     : OUT    std_logic_vector (11 DOWNTO 0);
      cram_we           : OUT    std_logic_vector (0 DOWNTO 0)  := "0";
      sd_write          : IN     std_logic ;
      sd_read           : IN     std_logic ;
      sd_read_ftu       : IN     std_logic ;
      sd_busy           : OUT    std_logic                      := '1';
      sd_started        : OUT    std_logic                      := '0';
      sd_started_ftu    : OUT    std_logic                      := '0';
      sd_ready          : OUT    std_logic                      := '0';
      sd_data_in        : IN     std_logic_vector (15 DOWNTO 0);
      sd_data_out       : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      sd_data_out_ftu   : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      sd_addr           : IN     std_logic_vector (11 DOWNTO 0);
      sd_addr_ftu       : IN     std_logic_vector (11 DOWNTO 0);
      config_start_cc   : IN     std_logic ;
      config_started_cc : OUT    std_logic                      := '0';
      config_ready_cc   : OUT    std_logic                      := '0';
      -- data from config ram
      general_settings  : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      lp_pt_freq        : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      lp_pt_ratio       : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      lp1_amplitude     : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      lp2_amplitude     : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      lp1_delay         : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      lp2_delay         : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      coin_n_p          : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      coin_n_c          : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      trigger_delay     : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      timemarker_delay  : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      dead_time         : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      cc_R0             : OUT    std_logic_vector (31 DOWNTO 0) := (others => '0');
      cc_R1             : OUT    std_logic_vector (31 DOWNTO 0) := (others => '0');
      cc_R8             : OUT    std_logic_vector (31 DOWNTO 0) := (others => '0');
      cc_R9             : OUT    std_logic_vector (31 DOWNTO 0) := (others => '0');
      cc_R11            : OUT    std_logic_vector (31 DOWNTO 0) := (others => '0');
      cc_R13            : OUT    std_logic_vector (31 DOWNTO 0) := (others => '0');
      cc_R14            : OUT    std_logic_vector (31 DOWNTO 0) := (others => '0');
      cc_R15            : OUT    std_logic_vector (31 DOWNTO 0) := (others => '0');
      coin_win_p        : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      coin_win_c        : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      ftu_active_cr0    : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      ftu_active_cr1    : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      ftu_active_cr2    : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      ftu_active_cr3    : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0')
   );
   END COMPONENT;
   COMPONENT dram_control
   PORT (
      clk                    : IN     std_logic ;
      dram_data_in           : OUT    std_logic_vector (15 DOWNTO 0);
      dram_data_out          : IN     std_logic_vector (15 DOWNTO 0);
      dram_addr_in           : OUT    std_logic_vector (11 DOWNTO 0);
      dram_addr_out          : OUT    std_logic_vector (11 DOWNTO 0);
      dram_we                : OUT    std_logic_vector (0 DOWNTO 0)  := "0";
      dd_block_start         : IN     std_logic ;
      dd_block_start_ftu     : IN     std_logic ;
      dd_block_start_ack     : OUT    std_logic                      := '0';
      dd_block_start_ack_ftu : OUT    std_logic                      := '0';
      dd_block_ready         : IN     std_logic ;
      dd_block_ready_ftu     : IN     std_logic ;
      dd_read                : IN     std_logic ;
      dd_write_ftu           : IN     std_logic ;
      dd_busy                : OUT    std_logic                      := '1';
      dd_started             : OUT    std_logic                      := '0';
      dd_started_ftu         : OUT    std_logic                      := '0';
      dd_ready               : OUT    std_logic                      := '0';
      dd_data_out            : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      dd_data_in_ftu         : IN     std_logic_vector (15 DOWNTO 0);
      dd_addr                : IN     std_logic_vector (11 DOWNTO 0);
      dd_addr_ftu            : IN     std_logic_vector (11 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT eth_config_modul
   PORT (
      clk                : IN     std_logic ;
      config_start_eth   : IN     std_logic ;
      config_started_eth : OUT    std_logic  := '0';
      config_ready_eth   : OUT    std_logic  := '0';
      config_start_cc    : OUT    std_logic  := '0';
      config_started_cc  : IN     std_logic ;
      config_ready_cc    : IN     std_logic 
   );
   END COMPONENT;
   COMPONENT fram_control
   PORT (
      clk            : IN     std_logic ;
      fram_data_in   : OUT    std_logic_vector (15 DOWNTO 0);
      fram_data_out  : IN     std_logic_vector (15 DOWNTO 0);
      fram_addr_in   : OUT    std_logic_vector (11 DOWNTO 0);
      fram_addr_out  : OUT    std_logic_vector (11 DOWNTO 0);
      fram_we        : OUT    std_logic_vector (0 DOWNTO 0)  := "0";
      fl_read        : IN     std_logic ;
      fl_write_ftu   : IN     std_logic ;
      fl_busy        : OUT    std_logic                      := '1';
      fl_started     : OUT    std_logic                      := '0';
      fl_started_ftu : OUT    std_logic                      := '0';
      fl_ready       : OUT    std_logic                      := '0';
      fl_data_out    : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      fl_data_in_ftu : IN     std_logic_vector (15 DOWNTO 0);
      fl_addr        : IN     std_logic_vector (11 DOWNTO 0);
      fl_addr_ftu    : IN     std_logic_vector (11 DOWNTO 0)
   );
   END COMPONENT;
   COMPONENT w5300_modul
   PORT (
      clk                : IN     std_logic ;
      wiz_reset          : OUT    std_logic                      := '1';
      addr               : OUT    std_logic_vector (9 DOWNTO 0);
      data               : INOUT  std_logic_vector (15 DOWNTO 0);
      cs                 : OUT    std_logic                      := '1';
      wr                 : OUT    std_logic                      := '1';
      led                : OUT    std_logic_vector (7 DOWNTO 0)  := (others => '0');
      rd                 : OUT    std_logic                      := '1';
      int                : IN     std_logic ;
      busy               : OUT    std_logic                      := '1';
      new_config         : OUT    std_logic                      := '0';
      config_started     : IN     std_logic ;
      config_started_ack : OUT    std_logic                      := '0';
      --
      ping_ftu_start     : OUT    std_logic                      := '0';
      ping_ftu_started   : IN     std_logic ;
      ping_ftu_ready     : IN     std_logic ;
      --
      sd_addr            : OUT    std_logic_vector (11 DOWNTO 0);
      sd_data_out        : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      sd_data_in         : IN     std_logic_vector (15 DOWNTO 0);
      sd_write           : OUT    std_logic                      := '0';
      sd_read            : OUT    std_logic                      := '0';
      sd_started         : IN     std_logic ;
      sd_ready           : IN     std_logic ;
      sd_busy            : IN     std_logic ;
      --
      dd_block_start     : OUT    std_logic                      := '0';
      dd_block_start_ack : IN     std_logic ;
      dd_block_ready     : OUT    std_logic                      := '0';
      dd_addr            : OUT    std_logic_vector (11 DOWNTO 0);
      dd_data_in         : IN     std_logic_vector (15 DOWNTO 0);
      dd_read            : OUT    std_logic                      := '0';
      dd_started         : IN     std_logic ;
      dd_ready           : IN     std_logic ;
      dd_busy            : IN     std_logic ;
      --
      fl_addr            : OUT    std_logic_vector (11 DOWNTO 0);
      fl_data_in         : IN     std_logic_vector (15 DOWNTO 0);
      fl_read            : OUT    std_logic                      := '0';
      fl_started         : IN     std_logic ;
      fl_ready           : IN     std_logic ;
      fl_busy            : IN     std_logic 
   );
   END COMPONENT;

   -- Optional embedded configurations
   -- pragma synthesis_off
   -- FOR ALL : CRAM_4096_16b USE ENTITY FACT_FTM_lib.CRAM_4096_16b;
   -- FOR ALL : DRAM_4096_16b USE ENTITY FACT_FTM_lib.DRAM_4096_16b;
   -- FOR ALL : FRAM_4096_16b USE ENTITY FACT_FTM_lib.FRAM_4096_16b;
   -- FOR ALL : cram_control USE ENTITY FACT_FTM_lib.cram_control;
   -- FOR ALL : dram_control USE ENTITY FACT_FTM_lib.dram_control;
   -- FOR ALL : eth_config_modul USE ENTITY FACT_FTM_lib.eth_config_modul;
   -- FOR ALL : fram_control USE ENTITY FACT_FTM_lib.fram_control;
   -- FOR ALL : w5300_modul USE ENTITY FACT_FTM_lib.w5300_modul;
   -- pragma synthesis_on


BEGIN

   -- ModuleWare code(v1.9) for instance 'U_3' of 'or'
   led <= led1 OR led2;

   -- Instance port mappings.
   U_1 : CRAM_4096_16b
      PORT MAP (
         clka  => clk,
         dina  => cram_data_in,
         addra => cram_addr_in,
         wea   => cram_we,
         clkb  => clk,
         addrb => cram_addr_out,
         doutb => cram_data_out
      );
   U_7 : DRAM_4096_16b
      PORT MAP (
         clka  => clk,
         dina  => dram_data_in,
         addra => dram_addr_in,
         wea   => dram_we,
         clkb  => clk,
         addrb => dram_addr_out,
         doutb => doutb1
      );
   U_5 : FRAM_4096_16b
      PORT MAP (
         clka  => clk,
         dina  => fram_data_in,
         addra => fram_addr_in,
         wea   => fram_we,
         clkb  => clk,
         addrb => fram_addr_out,
         doutb => doutb
      );
   U_2 : cram_control
      PORT MAP (
         clk               => clk,
         led               => led2,
         cram_data_in      => cram_data_in,
         cram_data_out     => cram_data_out,
         cram_addr_in      => cram_addr_in,
         cram_addr_out     => cram_addr_out,
         cram_we           => cram_we,
         sd_write          => sd_write,
         sd_read           => sd_read,
         sd_read_ftu       => sd_read_ftu,
         sd_busy           => sd_busy_internal,
         sd_started        => sd_started,
         sd_started_ftu    => sd_started_ftu,
         sd_ready          => sd_ready_internal,
         sd_data_in        => sd_data_in,
         sd_data_out       => sd_data_out,
         sd_data_out_ftu   => sd_data_out_ftu,
         sd_addr           => sd_addr,
         sd_addr_ftu       => sd_addr_ftu,
         config_start_cc   => config_start_cc,
         config_started_cc => config_started_cc,
         config_ready_cc   => config_ready_cc,
         general_settings  => general_settings,
         lp_pt_freq        => lp_pt_freq,
         lp_pt_ratio       => lp_pt_ratio,
         lp1_amplitude     => lp1_amplitude,
         lp2_amplitude     => lp2_amplitude,
         lp1_delay         => lp1_delay,
         lp2_delay         => lp2_delay,
         coin_n_p          => coin_n_p,
         coin_n_c          => coin_n_c,
         trigger_delay     => trigger_delay,
         timemarker_delay  => timemarker_delay,
         dead_time         => dead_time,
         cc_R0             => cc_R0,
         cc_R1             => cc_R1,
         cc_R8             => cc_R8,
         cc_R9             => cc_R9,
         cc_R11            => cc_R11,
         cc_R13            => cc_R13,
         cc_R14            => cc_R14,
         cc_R15            => cc_R15,
         coin_win_p        => coin_win_p,
         coin_win_c        => coin_win_c,
         ftu_active_cr0    => ftu_active_cr0,
         ftu_active_cr1    => ftu_active_cr1,
         ftu_active_cr2    => ftu_active_cr2,
         ftu_active_cr3    => ftu_active_cr3
      );
   U_8 : dram_control
      PORT MAP (
         clk                    => clk,
         dram_data_in           => dram_data_in,
         dram_data_out          => doutb1,
         dram_addr_in           => dram_addr_in,
         dram_addr_out          => dram_addr_out,
         dram_we                => dram_we,
         dd_block_start         => dd_block_start,
         dd_block_start_ftu     => dd_block_start_ftu,
         dd_block_start_ack     => dd_block_start_ack,
         dd_block_start_ack_ftu => dd_block_start_ack_ftu,
         dd_block_ready         => dd_block_ready,
         dd_block_ready_ftu     => dd_block_ready_ftu,
         dd_read                => dd_read,
         dd_write_ftu           => dd_write_ftu,
         dd_busy                => dd_busy_internal,
         dd_started             => dd_started,
         dd_started_ftu         => dd_started_ftu,
         dd_ready               => dd_ready_internal,
         dd_data_out            => dd_data_out,
         dd_data_in_ftu         => dd_data_in_ftu,
         dd_addr                => dd_addr,
         dd_addr_ftu            => dd_addr_ftu
      );
   U_4 : eth_config_modul
      PORT MAP (
         clk                => clk,
         config_start_eth   => config_start_eth,
         config_started_eth => config_started_eth,
         config_ready_eth   => config_ready_eth,
         config_start_cc    => config_start_cc,
         config_started_cc  => config_started_cc,
         config_ready_cc    => config_ready_cc
      );
   U_6 : fram_control
      PORT MAP (
         clk            => clk,
         fram_data_in   => fram_data_in,
         fram_data_out  => doutb,
         fram_addr_in   => fram_addr_in,
         fram_addr_out  => fram_addr_out,
         fram_we        => fram_we,
         fl_read        => fl_read,
         fl_write_ftu   => fl_write_ftu,
         fl_busy        => fl_busy_internal,
         fl_started     => fl_started,
         fl_started_ftu => fl_started_ftu,
         fl_ready       => fl_ready_internal,
         fl_data_out    => fl_data_out,
         fl_data_in_ftu => fl_data_in_ftu,
         fl_addr        => fl_addr,
         fl_addr_ftu    => fl_addr_ftu
      );
   U_0 : w5300_modul
      PORT MAP (
         clk                => clk,
         wiz_reset          => wiz_reset,
         addr               => wiz_addr,
         data               => wiz_data,
         cs                 => wiz_cs,
         wr                 => wiz_wr,
         led                => led1,
         rd                 => wiz_rd,
         int                => wiz_int,
         busy               => busy,
         new_config         => new_config,
         config_started     => config_started,
         config_started_ack => config_started_ack,
         ping_ftu_start     => ping_ftu_start,
         ping_ftu_started   => ping_ftu_started,
         ping_ftu_ready     => ping_ftu_ready,
         sd_addr            => sd_addr,
         sd_data_out        => sd_data_in,
         sd_data_in         => sd_data_out,
         sd_write           => sd_write,
         sd_read            => sd_read,
         sd_started         => sd_started,
         sd_ready           => sd_ready_internal,
         sd_busy            => sd_busy_internal,
         dd_block_start     => dd_block_start,
         dd_block_start_ack => dd_block_start_ack,
         dd_block_ready     => dd_block_ready,
         dd_addr            => dd_addr,
         dd_data_in         => dd_data_out,
         dd_read            => dd_read,
         dd_started         => dd_started,
         dd_ready           => dd_ready_internal,
         dd_busy            => dd_busy_internal,
         fl_addr            => fl_addr,
         fl_data_in         => fl_data_out,
         fl_read            => fl_read,
         fl_started         => fl_started,
         fl_ready           => fl_ready_internal,
         fl_busy            => fl_busy_internal
      );

   -- Implicit buffered output assignments
   dd_busy  <= dd_busy_internal;
   dd_ready <= dd_ready_internal;
   fl_busy  <= fl_busy_internal;
   fl_ready <= fl_ready_internal;
   sd_busy  <= sd_busy_internal;
   sd_ready <= sd_ready_internal;

END beha;
