--
-- VHDL Architecture FACT_FTM_lib.fram_control.beha
--
-- Created:
--          by - kai.UNKNOWN (E5PCXX)
--          at - 11:47:24 21.02.2011
--
-- using Mentor Graphics HDL Designer(TM) 2009.1 (Build 12)
--
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;
USE IEEE.STD_LOGIC_UNSIGNED.all;
-- LIBRARY FACT_FTM_lib;
-- USE FACT_FTM_lib.ftm_array_types.all;
-- USE FACT_FTM_lib.ftm_constants.all;
library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;

ENTITY fram_control IS
   PORT( 
      clk            : IN     std_logic;
      fram_data_in   : OUT    std_logic_vector (15 DOWNTO 0);
      fram_data_out  : IN     std_logic_vector (15 DOWNTO 0);
      fram_addr_in   : OUT    std_logic_vector (11 DOWNTO 0);
      fram_addr_out  : OUT    std_logic_vector (11 DOWNTO 0);
      fram_we        : OUT    std_logic_vector (0 DOWNTO 0)  := "0";
      fl_read        : IN     std_logic;
      fl_write_ftu   : IN     std_logic;
      fl_busy        : OUT    std_logic                      := '1';
      fl_started     : OUT    std_logic                      := '0';
      fl_started_ftu : OUT    std_logic                      := '0';
      fl_ready       : OUT    std_logic                      := '0';
      fl_data_out    : OUT    std_logic_vector (15 DOWNTO 0) := (others => '0');
      fl_data_in_ftu : IN     std_logic_vector (15 DOWNTO 0);
      fl_addr        : IN     std_logic_vector (11 DOWNTO 0);
      fl_addr_ftu    : IN     std_logic_vector (11 DOWNTO 0)
   );

-- Declarations

END fram_control ;

--
ARCHITECTURE beha OF fram_control IS
  
  type state_fram_proc_type is (FR_INIT, FR_CONFIG, FR_IDLE, FR_DOUT_WIZ_START, FR_DOUT_WIZ_END, FR_WRITE_START, FR_WRITE_END,
                                FR_READ_START, FR_READ_WAIT, FR_READ_END);
                                
  signal state_fram_proc  : state_fram_proc_type := FR_INIT;
  signal next_state       : state_fram_proc_type := FR_IDLE;

  signal local_addr  : std_logic_vector (11 downto 0) := X"000";
  signal local_data  : std_logic_vector (15 downto 0);
 
BEGIN

  fram_proc : process (clk)
  begin
    if rising_edge (clk) then
      case state_fram_proc is

        when FR_INIT =>
          state_fram_proc <= FR_CONFIG;

        when FR_CONFIG =>
          state_fram_proc <= FR_IDLE;
          
        when FR_IDLE =>
          fl_busy <= '0';
          
          if (fl_read = '1') then
            fl_busy <= '1';
            fl_started <= '1';
            fl_ready <= '0';
            local_addr <= fl_addr;
            next_state <= FR_DOUT_WIZ_START;
            state_fram_proc <= FR_READ_START;
            
          elsif (fl_write_ftu = '1') then
            fl_busy <= '1';
            fl_started_ftu <= '1';
            fl_ready <= '0';
            local_addr <= fl_addr_ftu;
            local_data <= fl_data_in_ftu;
            next_state <= FR_IDLE;
            state_fram_proc <= FR_WRITE_START;
          end if;



        when FR_DOUT_WIZ_START =>
          fl_data_out <= local_data;
          fl_ready <= '1';
          state_fram_proc <= FR_DOUT_WIZ_END;
          
        when FR_DOUT_WIZ_END =>
          if (fl_read <= '0') then
            fl_started <= '0';
            state_fram_proc <= FR_IDLE;
          end if;

        -- --
        -- write to ftu-list ram
        -- --
        when FR_WRITE_START =>
          fram_addr_in <= local_addr;
          fram_data_in <= local_data;
          fram_we <= "1";
          state_fram_proc <= FR_WRITE_END;
          
        when FR_WRITE_END =>
          fram_we <= "0";
          fl_started_ftu <= '0';
          fl_ready <= '1';
          state_fram_proc <= next_state;

        -- --
        -- read from ftu-list ram
        -- --
        when FR_READ_START =>
          fram_addr_out <= local_addr;
          state_fram_proc <= FR_READ_WAIT;
          
        when FR_READ_WAIT =>
          state_fram_proc <= FR_READ_END;
          
        when FR_READ_END =>
          local_data <= fram_data_out;
          state_fram_proc <= next_state;


      end case;
    end if; -- rising edge
  end process fram_proc;

END ARCHITECTURE beha;
