--------------------------------------------------------------------------------
-- Company: 
-- Engineer:      Patrick Vogler
--
-- Create Date:   16:19:23 02/21/2011
-- Design Name:   
-- Module Name:   
-- Project Name:  Clock_cond_interface
-- Target Device:  
-- Tool versions:  
-- Description:   
-- 
-- VHDL Test Bench Created by ISE for module: Clock_cond_interface
-- 
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
-- Notes: 
-- This testbench has been automatically generated using types std_logic and
-- std_logic_vector for the ports of the unit under test.  Xilinx recommends
-- that these types always be used for the top-level I/O of a design in order
-- to guarantee that the testbench will bind correctly to the post-implementation 
-- simulation model.
--------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.all;
USE ieee.numeric_std.ALL;
 
  
library ftm_definitions; 
use ftm_definitions.ftm_array_types.all;
use ftm_definitions.ftm_constants.all;

 
ENTITY Clock_cond_interface_tb IS
END Clock_cond_interface_tb;
 
ARCHITECTURE behavior OF Clock_cond_interface_tb IS 
 
    -- Component Declaration for the Unit Under Test (UUT)
 
    COMPONENT Clock_cond_interface
    PORT(
         clk : IN  std_logic;
         CLK_Clk_Cond : OUT  std_logic;
         LE_Clk_Cond : OUT  std_logic;
         DATA_Clk_Cond : OUT  std_logic;
         SYNC_Clk_Cond : OUT  std_logic;
         LD_Clk_Cond : IN  std_logic;
         TIM_Sel : OUT  std_logic;
         cc_R0 : IN  std_logic_vector(31 downto 0);
         cc_R1 : IN  std_logic_vector(31 downto 0);
         cc_R8 : IN  std_logic_vector(31 downto 0);
         cc_R9 : IN  std_logic_vector(31 downto 0);
         cc_R11 : IN  std_logic_vector(31 downto 0);
         cc_R13 : IN  std_logic_vector(31 downto 0);
         cc_R14 : IN  std_logic_vector(31 downto 0);
         cc_R15 : IN  std_logic_vector(31 downto 0);

         
         start_config : IN  std_logic;
         config_started : OUT  std_logic;
         config_done : OUT  std_logic;
         timemarker_select : IN  std_logic
        );
    END COMPONENT;
    

   --Inputs
   signal clk : std_logic := '0';
   signal LD_Clk_Cond : std_logic := '0';

    
   signal cc_R0 : std_logic_vector(31 downto 0)  := x"00010100";
   signal cc_R1 : std_logic_vector(31 downto 0)  := x"00010101";
   signal cc_R8 : std_logic_vector(31 downto 0)  := x"10000908";
   signal cc_R9 : std_logic_vector(31 downto 0)  := x"A0032A09";
   signal cc_R11 : std_logic_vector(31 downto 0) := x"0082000B";
   signal cc_R13 : std_logic_vector(31 downto 0) := x"020A000D";
   signal cc_R14 : std_logic_vector(31 downto 0) := x"0830280E";
   signal cc_R15 : std_logic_vector(31 downto 0) := x"2000960F";

    
   signal start_config : std_logic := '0';
   signal timemarker_select : std_logic := '0';




    
 	--Outputs
   signal CLK_Clk_Cond : std_logic;
   signal LE_Clk_Cond : std_logic;
   signal DATA_Clk_Cond : std_logic;
   signal SYNC_Clk_Cond : std_logic;
   signal TIM_Sel : std_logic;
   signal config_started : std_logic;
   signal config_done : std_logic;


    
   -- Clock period definitions
   constant clk_period : time := 20 ns;  -- 50 MHz Clock    
   --   constant CLK_Clk_Cond_period : time := 10 ns;


    
BEGIN
 
	-- Instantiate the Unit Under Test (UUT)
   uut: Clock_cond_interface PORT MAP (
          clk => clk,
          CLK_Clk_Cond => CLK_Clk_Cond,
          LE_Clk_Cond => LE_Clk_Cond,
          DATA_Clk_Cond => DATA_Clk_Cond,
          SYNC_Clk_Cond => SYNC_Clk_Cond,
          LD_Clk_Cond => LD_Clk_Cond,
          TIM_Sel => TIM_Sel,
          cc_R0 => cc_R0,
          cc_R1 => cc_R1,
          cc_R8 => cc_R8,
          cc_R9 => cc_R9,
          cc_R11 => cc_R11,
          cc_R13 => cc_R13,
          cc_R14 => cc_R14,
          cc_R15 => cc_R15,
          start_config => start_config,
          config_started => config_started,
          config_done => config_done,
          timemarker_select => timemarker_select
        );



   
   -- Clock process definitions
   clk_process :process
   begin
		clk <= '0';
		wait for clk_period/2;
		clk <= '1';
		wait for clk_period/2;
   end process;
 
--   CLK_Clk_Cond_process :process
--   begin
--		CLK_Clk_Cond <= '0';
--		wait for CLK_Clk_Cond_period/2;
--		CLK_Clk_Cond <= '1';
--		wait for CLK_Clk_Cond_period/2;
--   end process;
 


   
   -- Stimulus process
   stim_proc: process
   begin		
      -- hold reset state for 100 ms.
    --  wait for 100 ms;

      TIM_Sel <= '0';
     
      wait for clk_period*20;

      -- insert stimulus here 

      start_config <= '1';
      wait for clk_period*100;
      start_config <= '0'; 
          
		wait for 180 us;
      LD_Clk_Cond <= '1';		
      
      wait;
   end process;

END;
