----------------------------------------------------------------------------------
-- Company:        ETH Zurich, Institute for Particle Physics
-- Engineer:       P. Vogler, Q. Weitzel
--
-- Create Date:    07/14/2010
-- Design Name:
-- Module Name:     FTM_test3_microwire_interface - Behavioral
--                  (based on FTU_test5_spi_interface - Behavioral)
-- Project Name:
-- Target Devices:
-- Tool versions:
-- Description:    Based on VHDL Entity FACT_FAD_lib.spi_interface.symbol
--
-- Dependencies:
--
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
--
--
-- modified by Patrick Vogler, September 17 2010
-- for use as a microwire interface to the clock conditioner LMK03000
-- on the FTM board
--
-- modified by Patrick Vogler, February 15 2011
-- to be used as an FTM firmware clock conditioner interface
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

library ftm_definitions;
USE ftm_definitions.ftm_array_types.all;
USE ftm_definitions.ftm_constants.all;



-------------------------------------------------------------------------------
---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

ENTITY microwire_interface IS
   PORT(
      clk               : IN     std_logic;              -- 50MHz
      clk_uwire         : OUT     std_logic;             -- sclk
      data_uwire        : OUT    std_logic := '0';       -- mosi
      le_uwire          : OUT    std_logic := '1';       -- Latch Enable = chip select
      clk_cond_array    : IN     clk_cond_array_type;    -- data to be loaded
                                                         -- into the clock conditioner
      config_start      : IN     std_logic;
      config_ready      : OUT    std_logic := '0'; 
      config_started    : OUT    std_logic := '0'     
   );
END microwire_interface;
   

ARCHITECTURE struct OF microwire_interface IS

   -- Internal signal declarations
   SIGNAL clk_uwire_sig       : std_logic;

   
   -- Component Declarations  
   COMPONENT microwire_clock_gen  
   GENERIC (
      CLK_DIVIDER : integer := INT_CLK_FREQUENCY_1 / MICROWIRE_CLK_FREQUENCY   --2 MHz @ 50 MHz
   );
   PORT (
      clk  : IN     std_logic;
      sclk : OUT    std_logic  := '0'
   );
   END COMPONENT;

   
   COMPONENT microwire_controller
   PORT (
      clk_uwire         : IN     std_logic;              -- sclk
      data_uwire        : OUT    std_logic := '0';       -- mosi
      le_uwire          : OUT    std_logic := '1';       -- Latch Enable = chip select
      clk_cond_array    : IN     clk_cond_array_type;    -- data to be loaded
                                                         -- into the clock conditioner
      config_start      : IN     std_logic;
      config_ready      : OUT    std_logic := '0'; 
      config_started    : OUT    std_logic := '0'
   );
   END COMPONENT;


   
BEGIN

   -- Instance port mappings.
   Inst_microwire_clock_gen : microwire_clock_gen
      GENERIC MAP (
         CLK_DIVIDER => INT_CLK_FREQUENCY_1 / MICROWIRE_CLK_FREQUENCY   --2 MHz @ 50 MHz
      )
      PORT MAP (
         clk  => clk,
         sclk => clk_uwire_sig
      );
   
   Inst_microwire_controller : microwire_controller
      PORT MAP (
         clk_uwire         => clk_uwire_sig,
         data_uwire        => data_uwire,         
         le_uwire          => le_uwire,         
         clk_cond_array    => clk_cond_array,         
         config_start      => config_start,
         config_ready      => config_ready,
         config_started    => config_started
      );

   clk_uwire<= clk_uwire_sig;
   
END struct;
